/*++TextListFloatProp.java++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.Iterator;
import  java.util.StringTokenizer;
import  java.util.Vector;


/**
 * TextListFloatProp: base class for ICalendar float-valued properties
 * that specify a (comma-separated) list of floats.
 *
 * @author slh
 * @version 0.00 2001/05/22 slh
 */
abstract public
class  TextListFloatProp
extends  TextListProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  protected
  TextListFloatProp  (		)
  {
    this( null );	/* get default name */
  }


  /* Note: this is the base constructor */
  protected
  TextListFloatProp  (String	strName	)
  {
    super( strName != null ? strName : "TextListFloatProp" );

    m_vector = new Vector(  );
  }


  /* Convenience */
  protected
  TextListFloatProp  (String	strName		,
		      String	strValues	)
  throws Exception	/* to support subclasses/required by superclass */
  {
    /*Note: letting calls handle any nulls*/

    this( strName );

    set( strValues );
  }


  protected
  TextListFloatProp  (String	strName	,
		      int	Min	,
		      int	Max	)
  {
    /*Note: letting calls handle any nulls*/

    this( strName );

    setMinMax( Min , Max );
  }


  /* Convenience */
  protected
  TextListFloatProp  (String	strName		,
		      int	Min		,
		      int	Max		,
		      String	strValues	)
  throws Exception	/* to support subclasses/required by superclass */
  {
    /*Note: letting calls handle any nulls*/

    this( strName , Min , Max );

    set( strValues );
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  /***
   * Note: returning value as a float primitive.
   */
  /* Convenience */
  public
  float
  getFirstFloat  (		)
  throws NoValueException
  {
    return ((Float)getFirst(  )).floatValue(  );
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  protected
  void
  addDirect  (Object	object	)
  throws Exception
  {
    if        (object instanceof Float) {
      m_vector.addElement( object );
    } else if (object instanceof String) {
      addTextDirect( (String)object );
    } else {
      throw new WrongClassException(
		getName(  ) + ": object of wrong class" );
    }
  }


  protected
  void
  addTextDirect  (String	strText	)
  throws Exception	/* NumberFormatException  */
  {
    m_vector.addElement( Float.valueOf( strText ) );
  }


/*----------------------------------------------------------------------------
 *						Main
 *--------------------------------------------------------------------------*/

  static public
  void
  main  (String		argv[]	)
  {
    XProp	xprop	= new XProp( "testx" );
    Geo		geo	= new Geo(  );
    Vector	vector	= new Vector(  );
    Iterator	enum;
    Object	object;

    try {
      System.out.println( xprop );
      xprop.set( "one" );
      System.out.println( xprop );

      System.out.println( geo );
      geo.addTexts( "1.0" );
      System.out.println( geo.isComplete(  ) );
      geo.addTexts( "2.00" );
      System.out.println( geo.isComplete(  ) );
      System.out.println( geo );

      vector.addElement( new Float( 90 ) );
      vector.addElement( new Float( 180 ) );
      geo.set(vector.iterator());
      System.out.println( geo );

      vector.removeAllElements(  );
      vector.addElement( new Float( 270 ) );
      vector.addElement( "360" );
      geo.set(vector.iterator());
      System.out.println( geo );

      enum = geo.getList(  );
      for ( ; enum.hasNext(  ) ; ) {
	object = enum.next(  );
	System.out.println( object + ":" + (object instanceof Float) );
      }

      geo.addTexts( "3" );
    } catch (Exception	e	) {
      e.printStackTrace(  );
    }
  }


}


/* Log:
 *  0.00  2001/05/22  slh
 *        create
 */
/*--TextListFloatProp.java--------------------------------------------------*/
