/*++TextListFloatParam.java+++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.Iterator;
import  java.util.StringTokenizer;
import  java.util.Vector;


/**
 * TextListFloatParam: base class for ICalendar float-valued parameters
 * that specify a (comma-separated) list of floats.
 *
 * @author slh
 * @version 0.00 2001/05/22 slh
 */
abstract public
class  TextListFloatParam
extends  TextListParam
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  protected
  TextListFloatParam  (		)
  {
    this( null );	/* get default name */
  }


  /* Note: this is the base constructor */
  protected
  TextListFloatParam  (String	strName	)
  {
    super( strName != null ? strName : "TextListFloatParam" );

    m_vector = new Vector(  );
  }


  /* Convenience */
  protected
  TextListFloatParam  (String	strName		,
		       String	strValues	)
  throws Exception	/* to support subclasses/required by superclass */
  {
    /*Note: letting calls handle any nulls*/

    this( strName );

    set( strValues );
  }


  protected
  TextListFloatParam  (String	strName	,
		       int	Min	,
		       int	Max	)
  {
    /*Note: letting calls handle any nulls*/

    this( strName );

    setMinMax( Min , Max );
  }


  /* Convenience */
  protected
  TextListFloatParam  (String	strName		,
		       int	Min		,
		       int	Max		,
		       String	strValues	)
  throws Exception	/* to support subclasses/required by superclass */
  {
    /*Note: letting calls handle any nulls*/

    this( strName , Min , Max );

    set( strValues );
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  /***
   * Note: returning value as a float primitive.
   */
  /* Convenience */
  public
  float
  getFirstFloat  (		)
  throws NoValueException
  {
    return ((Float)getFirst(  )).floatValue(  );
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  protected
  void
  addDirect  (Object	object	)
  throws Exception
  {
    if        (object instanceof Float) {
      m_vector.addElement( object );
    } else if (object instanceof String) {
      addTextDirect( (String)object );
    } else {
      throw new WrongClassException(
		getName(  ) + ": object of wrong class" );
    }
  }


  protected
  void
  addTextDirect  (String	strText	)
  throws Exception	/* NumberFormatException  */
  {
    m_vector.addElement( Float.valueOf( strText ) );
  }


/*----------------------------------------------------------------------------
 *						Main
 *--------------------------------------------------------------------------*/

  /*Note: this only works when abstract removed from class decl*/
//  static public
//  void
//  main  (String		argv[]	)
//  {
//    XParam		xparam	= new XParam( "testx" );
//    TextListFloatParam	tlfp	= new TextListFloatParam( "testf" , 3 , 3 );
//
//    try {
//      System.out.println( xparam );
//      xparam.addTexts( "one,two,three" );
//      System.out.println( xparam );
//
//      System.out.println( tlfp );
//      tlfp.addTexts( "1.0,2.00" );
//      System.out.println( tlfp.isComplete(  ) );
//      tlfp.addTexts( "3" );
//      System.out.println( tlfp.isComplete(  ) );
//      System.out.println( tlfp );
//
//      tlfp.addTexts( "4.0" );
//    } catch (Exception	e	) {
//      e.printStackTrace(  );
//    }
//  }


}


/* Log:
 *  0.00  2001/05/22  slh
 *        create
 */
/*--TextListFloatParam.java-------------------------------------------------*/
