/*++TZName.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.Vector;


/**
 * iCalendar TZNAME property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 *   section:	4.8.3.2 [2445]
 *   occurs:	VTIMEZONE/STANDARD, VTIMEZONE/DAYLIGHT (0+)
 *   datatypes:	TEXT (1)
 *   default:	---
 *   allowed:	---
 *   params:	LANGUAGE (0-1), xparam(0+)
 *</PRE>
 *
 * @author  slh
 * @version  0.00 2003/02/19 slh
 */


public
class  TZName
extends  TextProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a TZNAME property, unset.
   */
  public
  TZName  (		)
  {
    super( getCalendarName(  ) );
  }


  /**
   * Create a TZNAME property set to the supplied value.
   */
  public
  TZName  (String	strValue	)
  {
    super( getCalendarName(  ) , strValue );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strProp_TZName;
  }



/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  /**
   * Configures property by populating m_vParam*.
   */
  protected
  void
  configProperty  (		)
  {
    m_vParamZeroOne = new Vector(  );
    /*void*/m_vParamZeroOne.add(
		Config.getParamClass( Names.strParam_Language ) );

    m_vParamZeroPlus = new Vector(  );
    /*void*/m_vParamZeroPlus.add( Config.getParamClass( Names.strParam_X ) );
  }

}


/* Log:
 *  0.00  2003/02/19  slh
 *        create
 */
/*--TZName.java-------------------------------------------------------------*/
