/*++Summary.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.Vector;


/**
 * iCalendar SUMMARY property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.8.1.12 [2445]
 *   occurs:	VEVENT, VTODO, VJOURNAL, VALARM (0-1)
 *   datatypes:	TEXT (1)
 *   default:	---
 *   allowed:	---
 *   params:	ALTREP(0-1), LANGUAGE(0-1), xparam(0+)
 *</PRE>
 *
 * @author  slh
 * @version  0.10a 2003/10/29 slh
 */
public
class  Summary
extends  TextProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a SUMMARY property, unset.
   */
  public
  Summary  (		)
  {
    super( getCalendarName(  ) );
  }


  /**
   * Create a SUMMARY property set to supplied value.
   */
  public
  Summary  (String	strValue	)
  {
    super( getCalendarName(  ) , strValue );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strProp_Summary;
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  /**
   * Configures property by populating m_vParam*.
   */
  protected
  void
  configProperty  (		)
  {
    m_vParamZeroPlus = new Vector(  );
    m_vParamZeroPlus.add( XParam.class );

    m_vParamZeroOne = new Vector(  );
    m_vParamZeroOne.add( AltRepParam.class );
    m_vParamZeroOne.add( LanguageParam.class );
  }

}


/* Log:
 *  0.10a 2003/10/29  slh
 *        comments
 *  0.10  2003/01/14, 2003/04/15  slh
 *        getCalendarName()
 *        derive directly from TextProp
 *        configProperty()
 *  0.00  2001/04/25, 2001/05/02  slh
 *        create
 */
/*--Summary.java------------------------------------------------------------*/
