/*++Strings.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


/**
 * Strings: ICalendar string constants, inducers, terminators, etc..
 *
 * @author  slh
 * @version  0.10 2003/07/15 slh
 */
abstract public
class  Strings
{

/*----------------------------------------------------------------------------
 *						Class Public Constants
 *--------------------------------------------------------------------------*/

  final static public  char	chCompValueInducer	= ':';
  final static public  char	chPropValueInducer	= ':';
  final static public  char	chPropEscape		= '\\';
  final static public  char	chPropValueListSep	= ',';
  final static public  char	chPropValueStructSep	= ',';
  final static public  char	chParamInducer		= ';';
  final static public  char	chParamValueInducer	= '=';
  final static public  char	chParamValueQuote	= '"';
  final static public  char	chParamValueSeparator	= ',';

  /* because sometimes you feel like a char and sometimes you don't...: */
  final static public  String	strCompValueInducer	=
				String.valueOf( chCompValueInducer );
  final static public  String	strPropValueInducer	=
				String.valueOf( chPropValueInducer );
  final static public  String	strPropEscape	=
				String.valueOf( chPropEscape );
  final static public  String	strPropValueListSep	=
				String.valueOf( chPropValueListSep );
  final static public  String	strPropValueStructSep	=
				String.valueOf( chPropValueStructSep );
  final static public  String	strParamInducer		=
				String.valueOf( chParamInducer );
  final static public  String	strParamValueInducer	=
				String.valueOf( chParamValueInducer );
  final static public  String	strParamValueQuote	=
				String.valueOf( chParamValueQuote );
  final static public  String	strParamValueSeparator	=
				String.valueOf( chParamValueSeparator );

  final static public  String	strBegin		= "BEGIN";
  final static public  String	strEnd			= "END";

  /*deprecated*/
  final static public  String	strValueInducer		= ":";
  final static public  String	strLineTerm		= "\r\n";

  final static public  String	strDelimiters		=
	strValueInducer + strParamInducer + strParamValueInducer +
	strLineTerm;

  final static public  String	strBaseComplement	=
		"\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007" +
		"\u0008\n\u000B\u000C\r\u000E\u000F" +
		"\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017" +
		"\u0018\u0019\u001A\u001B\u001C\u001D\u001E\u001F" +
		"\u007F" +
		"\u00F9\u00FA\u00FB\u00FC\u00FD\u00FE\u00FF";
  /*
     QSAFE-CHAR = WSP / %x21 / %x23-7E / NON-US-ASCII
     ; Any character except CTLs and DQUOTE
     WSP        = SPACE / HTAB
     NON-US-ASCII       = %x80-F8
     ; Use restricted by charset parameter
     ; on outer MIME object (UTF-8 preferred)
  */
  /* complement of QSAFE-CHAR */
  final static public  String	strQSafeComplement	=
		strBaseComplement + "\"";
  /*
     SAFE-CHAR  = WSP / %x21 / %x23-2B / %x2D-39 / %x3C-7E
                / NON-US-ASCII
     ; Any character except CTLs, DQUOTE, ";", ":", ","
     WSP        = SPACE / HTAB
     NON-US-ASCII       = %x80-F8
     ; Use restricted by charset parameter
     ; on outer MIME object (UTF-8 preferred)
  */
  /* complement of SAFE-CHAR */
  final static public  String	strSafeComplement	=
		strQSafeComplement + ";:,";
  /*
     text       = *(TSAFE-CHAR / ":" / DQUOTE / ESCAPED-CHAR)
     TSAFE-CHAR = %x20-21 / %x23-2B / %x2D-39 / %x3C-5B
                  %x5D-7E / NON-US-ASCII
        ; Any character except CTLs not needed by the current
        ; character set, DQUOTE, ";", ":", "\", ","
     DQUOTE     = %x22
     ESCAPED-CHAR = "\\" / "\;" / "\," / "\N" / "\n")
     NON-US-ASCII       = %x80-F8
     ; Use restricted by charset parameter
     ; on outer MIME object (UTF-8 preferred)
  */
  /* complement of text */
  final static public  String	strTextComplement	=
		strBaseComplement + "\t,;\\";
  final static public  String	strEscapeCodeComplement	=
		strTextComplement + "nN";
  final static public  String	astrPropEscapeCode[]	= {
    "\\",";",",","n","N",
  };
  final static public  String	astrPropEscapeValue[]	= {
    "\\",";",",","\n","\n",
  };

}


/* Log:
 *  0.10  2003/06/18, 2003/06/23, 2003/07/14 - 2003/07/15  slh
 *        added several, including char versions
 *  0.00  2001/11/20  slh
 *        create
 */
/*--Strings.java------------------------------------------------------------*/
