/*++Status.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.HashMap;


/**
 * iCalendar STATUS property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.8.1.11 [2445]
 *   occurs:	VEVENT, VTODO, VJOURNAL (0-1)
 *   datatypes:	TEXT/enum (1)
 *   default:	---
 *   allowed:	"TENTATIVE", "CONFIRMED", "CANCELLED",
 *		"NEEDS-ACTION", "COMPLETED", "IN-PROCESS", "DRAFT", "FINAL"
 *   params:	xparam(0+)
 *
 * Allowed values by context:
 *   VEVENT:	"TENTATIVE", "CONFIRMED", "CANCELLED"
 *   VTODO:	"NEEDS-ACTION", "COMPLETED", "IN-PROCESS", "CANCELLED"
 *   VJOURNAL:	"DRAFT", "FINAL", "CANCELLED"
 *</PRE>
 *
 * @author  slh
 * @version  0.10 2003/03/05 slh
 */
public
class  Status
extends  EnumProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a STATUS property, unset.
   */
  public
  Status  (		)
  {
    super( getCalendarName(  ) );
  }


  /**
   * Create a STATUS property set to supplied value.
   */
  public
  Status  (String	strValue	)
  {
    super( getCalendarName(  ) , strValue );
  }


  /**
   * Create a STATUS property set to supplied value.
   */
  public
  Status  (int	iValue	)
  {
    super( getCalendarName(  ) , iValue );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strProp_Status;
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  /*Note: overriding EnumProp.configEnum()
    which is called in EnumProp.EnumProp(*).
  */
  protected
  void
  configEnum  (		)
  {
    m_hmValue = new HashMap(  );
    /*(void)*/m_hmValue.put(
		new Integer( TENTATIVE ) , Names.strValue_Tentative );
    /*(void)*/m_hmValue.put(
		new Integer( CONFIRMED ) , Names.strValue_Confirmed );
    /*(void)*/m_hmValue.put(
		new Integer( CANCELLED ) , Names.strValue_Cancelled );
    /*(void)*/m_hmValue.put(
		new Integer( NEEDSACTION ) , Names.strValue_NeedsAction );
    /*(void)*/m_hmValue.put(
		new Integer( COMPLETED ) , Names.strValue_Completed );
    /*(void)*/m_hmValue.put(
		new Integer( INPROCESS ) , Names.strValue_InProcess );
    /*(void)*/m_hmValue.put( new Integer( DRAFT ) , Names.strValue_Draft );
    /*(void)*/m_hmValue.put( new Integer( FINAL ) , Names.strValue_Final );

    /* no default */
  }


/*----------------------------------------------------------------------------
 *						Class Public Constants
 *--------------------------------------------------------------------------*/

  final static public  int	TENTATIVE	= 1;
  final static public  int	CONFIRMED	= 2;
  final static public  int	CANCELLED	= 3;
  final static public  int	NEEDSACTION	= 4;
  final static public  int	COMPLETED	= 5;
  final static public  int	INPROCESS	= 6;
  final static public  int	DRAFT		= 7;
  final static public  int	FINAL		= 8;

}


/* Log:
 *  0.10  2003/03/05, 2003/04/22  slh
 *        rm main()
 *        redo constructors
 *        configEnum(): drop set(), setEnum()
 *        getCalendarName()
 *  0.00  2001/04/25, 2001/05/02, 2001/05/08 - 2001/05/09  slh
 *        create
 */
/*--Status.java-------------------------------------------------------------*/
