/*++Sequence.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;



/**
 * ICalendar SEQUENCE property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.8.7.4
 *   occurs:	0-1 (VEVENT,VTODO,VJOURNAL)
 *   datatypes:	INTEGER/nonnegative (1)
 *   default:	0
 *   allowed:	>= 0
 *   params:	xparam (0+)
 *</PRE>
 *
 * @author slh
 * @version 0.10 2002/11/06 slh
 */
public
class  Sequence
extends  NonnegativeIntegerProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a SEQUENCE property with default value.
   */
  public
  Sequence  (		)
  {
    super( Names.strProp_Sequence , mc_Default );
  }


  /**
   * Create a SEQUENCE property with indicated value.
   */
  public
  Sequence  (String	strValue	)
  {
    super( Names.strProp_Sequence , strValue );
  }


  /**
   * Create a SEQUENCE property with indicated value.
   */
  public
  Sequence  (Integer	IValue	)
  {
    super( Names.strProp_Sequence , IValue );
  }


  /**
   * Create a SEQUENCE property with indicated value.
   */
  public
  Sequence  (int	iValue	)
  {
    super( Names.strProp_Sequence , iValue );
  }


/*----------------------------------------------------------------------------
 *						Class Public Constants
 *--------------------------------------------------------------------------*/

  final static public  int	mc_Default	= 0;


/*----------------------------------------------------------------------------
 *						Main
 *--------------------------------------------------------------------------*/

  static public
  void  main  (String	argv[]	)
  {
    Sequence	sequence	= new Sequence(  );
    XParam	xparam;

    /*void*/System.out.println( sequence );

    /*void*/sequence.set( 9 );
    /*void*/System.out.println( sequence );

    try {
      xparam = new XParam( "X-CAC-XXX" , "yyy" );
      /*void*/sequence.addParameter( xparam );
      /*void*/System.out.println( sequence );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }

    try {
      /*void*/System.out.println( sequence.get(  ) );
    } catch (ICalendarException	e	) {
      /*void*/e.printStackTrace(  );
    }

    /*void*/System.out.println(
		"NOTE: should throw IllegalArgumentException:" );
    try {
      /*void*/sequence.set( -1 );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e.getLocalizedMessage(  ) );
    }
    /*void*/System.out.println( sequence );
  }

}


/* Log:
 *  0.10  2002/10/30, 2002/11/06  slh
 *        derive from NonnegativeIntegerProp (instead of IntProp)
 *  0.01  2001/05/17  slh
 *        rm unnec throws decl
 *        adjust for change in XParam
 *  0.00  2001/04/25, 2001/05/02  slh
 *        create
 */
/*--Sequence.java-----------------------------------------------------------*/
