/*++RoleParam.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.HashMap;


/**
 * iCalendar ROLE (participation ROLE) parameter.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.2.16 [2445]
 *   occurs:	<CAL-ADDRESS-valued properties> (1)
 *   datatypes:	TEXT (1)
 *   default:	"REQ-PARTICIPANT"
 *   allowed:	"CHAIR",
 *              "REQ-PARTICIPANT", "OPT-PARTICIPANT", "NON-PARTICIPANT",
 *              iana-token, x-name
 *</PRE>
 *
 * @author  slh
 * @version  0.10 2003/10/21 slh
 */
public
class  RoleParam
extends  EnumParam
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a ROLE parameter set to default.
   */
  public
  RoleParam  (		)
  {
    super( getCalendarName(  ) );
  }


  /**
   * Create a ROLE parameter set to supplied string value.
   */
  public
  RoleParam  (String	strValue	)
  {
    super( getCalendarName(  ) , strValue );
  }


  /**
   * Create a ROLE parameter set to supplied id value.
   */
  public
  RoleParam  (int	iValue	)
  {
    super( getCalendarName(  ) , iValue );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strParam_Role;
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  /*Note: overriding EnumProp.configEnum()
    which is called in EnumProp.EnumProp(*).
  */
  protected
  void
  configEnum  (		)
  {
    m_hmValue = new HashMap(  );
    m_hmValue.put( new Integer( CHAIR ) , Names.strValue_Chair );
    m_hmValue.put( new Integer( REQPARTICIPANT ) ,
		   Names.strValue_ReqParticipant );
    m_hmValue.put( new Integer( OPTPARTICIPANT ) ,
		   Names.strValue_OptParticipant );
    m_hmValue.put( new Integer( NONPARTICIPANT ) ,
		   Names.strValue_NonParticipant );
    m_hmValue.put( new Integer( IANATOKEN ) , null );
    m_hmValue.put( new Integer( XNAME ) , null );

    m_strDefault = Names.strValue_ReqParticipant;
  }


/*----------------------------------------------------------------------------
 *						Class Public Constants
 *--------------------------------------------------------------------------*/

  final static public  int	CHAIR		= 1;
  final static public  int	REQPARTICIPANT	= 2;
  final static public  int	OPTPARTICIPANT	= 3;
  final static public  int	NONPARTICIPANT	= 4;


/*----------------------------------------------------------------------------
 *						Main
 *--------------------------------------------------------------------------*/

  static public
  void  main  (String	argv[]	)
  {
    RoleParam	roleparam		= new RoleParam(  );

    /*void*/System.out.println( roleparam );

    try {
      /*void*/roleparam.set( "OPT-PARTICIPANT" );
      /*void*/System.out.println( roleparam );

      /*void*/roleparam.set( NONPARTICIPANT );
      /*void*/System.out.println( roleparam );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }

    /*void*/System.out.println( roleparam.get(  ) );
    /*void*/System.out.println( roleparam.getEnum(  ) );

    /*void*/System.out.println(
		"NOTE: should throw IllegalArgumentException:" );
    try {
      /*void*/roleparam.set( 666 );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e );
    }
    /*void*/System.out.println(
		"NOTE: should throw IllegalArgumentException:" );
    try {
      /*void*/roleparam.set( "six six six" );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e );
    }
    /*void*/System.out.println( roleparam );
  }

}


/* Log:
 *  0.10  2003/10/21  slh
 *        derive from EnumParam (rather than UnsupParam) based on RelTypeParam
 *  0.00  2001/05/15  slh
 *        create
 */
/*--RoleParam.java----------------------------------------------------------*/
