/*++Resources.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.Vector;


/**
 * iCalendar RESOURCES property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.8.1.10 [2445]
 *   occurs:	VEVENT (0+)
 *   datatypes:	TEXT (1+)
 *   default:	---
 *   allowed:	---
 *   params:	ALTREP(0-1), LANGUAGE(0-1), xparam(0+)
 *</PRE>
 *
 * @author  slh
 * @version  0.10 2003/04/15 slh
 */
public
class  Resources
extends  TextListProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a RESOURCES property, unset.
   */
  public
  Resources  (		)
  {
    super( getCalendarName(  ) );
  }


  /**
   * Create a RESOURCES property set to supplied value.
   */
  public
  Resources  (String	strValue	)
  {
    super( getCalendarName(  ) , strValue );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strProp_Resources;
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  /**
   * Configures property by populating m_vParam*.
   */
  protected
  void
  configProperty  (		)
  {
    m_vParamZeroPlus = new Vector(  );
    m_vParamZeroPlus.add( XParam.class );

    m_vParamZeroOne = new Vector(  );
    m_vParamZeroOne.add( AltRepParam.class );
    m_vParamZeroOne.add( LanguageParam.class );
  }

}


/* Log:
 *  0.10  2003/01/14, 2003/04/15  slh
 *        getCalendarName()
 *        configProperty()
 *  0.00  2001/05/15  slh
 *        create
 */
/*--Resources.java----------------------------------------------------------*/
