/*++RequestStatus.java++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.Vector;


/**
 * iCalendar REQUEST-STATUS property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 *   section:	4.8.8.2 [2445]
 *   occurs:	VEVENT, VTODO, VJOURNAL, VFREEBUSY (1)
 *   datatypes:	TEXT (1)
 *   default:	---
 *   allowed:	format: <d>[.<d>[.<d>]];<code>;<desc>[;<data>]
 *   params:	LANGUAGE(0-1), xparam(0+)
 *</PRE>
 *
 * @author  slh
 * @version  0.00 2003/04/15 slh
 */


public
class  RequestStatus
extends  TextProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a REQUEST-STATUS property, unset.
   */
  public
  RequestStatus  (		)
  {
    super( getCalendarName(  ) );
  }


  /**
   * Create a REQUEST-STATUS property set to the supplied value.
   */
  public
  RequestStatus  (String	strValue	)
  {
    super( getCalendarName(  ) , strValue );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strProp_RequestStatus;
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  void
  set  (String	strValue	)
  throws Exception
  {
//???check format of msg
    /*void*/super.set( strValue );
  }


  public
  void
  set  (String	strCode	,
	String	strDesc	,
	String	strData	)
  throws Exception
  {
    if (strCode == null) {
      throw new NullPointerException( getName(  ) + ":set()" +
		": strCode (String) is null" );
    }
    if (strCode == null) {
      throw new NullPointerException( getName(  ) + ":set()" +
		": strDesc (String) is null" );
    }

//???check format of msg
    /*void*/set( strCode + ";" + strDesc +
		 (strData == strData ? "" : ";" + strData) );
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  /**
   * Configures property by populating m_vParam*.
   */
  protected
  void
  configProperty  (		)
  {
    m_vParamZeroPlus = new Vector(  );
    m_vParamZeroPlus.add( XParam.class );

    m_vParamZeroOne = new Vector(  );
    m_vParamZeroOne.add( LanguageParam.class );
  }

}


/* Log:
 *  0.00  2003/02/10, 2003/04/15  slh
 *        create
 */
/*--RequestStatus.java------------------------------------------------------*/
