/*++Repeat.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


/**
 * iCalendar REPEAT property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.8.6.2 [2445]
 *   occurs:	VALARM (0-1)
 *   datatypes:	INTEGER/nonnegative (1)
 *   default:	0
 *   allowed:	>= 0
 *   params:	xparam(0+)
 *</PRE>
 *
 * @author  slh
 * @version  0.01 2003/10/29 slh
 */
public
class  Repeat
extends  NonnegativeIntegerProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a REPEAT property with default value.
   */
  public
  Repeat  (		)
  {
    super( getCalendarName(  ) , mc_Default );
  }


  /**
   * Create a REPEAT property with indicated value.
   */
  public
  Repeat  (String	strValue	)
  {
    super( getCalendarName(  ) , strValue );
  }


  /**
   * Create a REPEAT property with indicated value.
   */
  public
  Repeat  (Integer	IValue	)
  {
    super( getCalendarName(  ) , IValue );
  }


  /**
   * Create a REPEAT property with indicated value.
   */
  public
  Repeat  (int	iValue	)
  {
    super( getCalendarName(  ) , iValue );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strProp_Repeat;
  }


/*----------------------------------------------------------------------------
 *						Class Public Constants
 *--------------------------------------------------------------------------*/

  final static public  int	mc_Default	= 0;


/*----------------------------------------------------------------------------
 *						Main
 *--------------------------------------------------------------------------*/

  static public
  void  main  (String	argv[]	)
  {
    Repeat	repeat		= new Repeat(  );
    XParam	xparam;

    /*void*/System.out.println( repeat.isComplete(  ) );
    /*void*/System.out.println( repeat );

    /*void*/repeat.set( 9 );
    /*void*/System.out.println( repeat.isComplete(  ) );
    /*void*/System.out.println( repeat );

    try {
      xparam = new XParam( "X-CAC-XXX" , "yyy" );
      /*void*/repeat.addParameter( xparam );
      /*void*/System.out.println( repeat.isComplete(  ) );
      /*void*/System.out.println( repeat );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }

    try {
      /*void*/System.out.println( repeat.get(  ) );
    } catch (ICalendarException	e	) {
      /*void*/e.printStackTrace(  );
    }

    /*void*/System.out.println(
		"NOTE: should throw IllegalArgumentException:" );
    try {
      /*void*/repeat.set( -1 );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e );
    }
    /*void*/System.out.println( repeat.isComplete(  ) );
    /*void*/System.out.println( repeat );
  }

}


/* Log:
 *  0.01  2003/10/29  slh
 *        sync with current paradigms
 *  0.00  2002/11/06  slh
 *        create
 */
/*--Repeat.java-------------------------------------------------------------*/
