/*++RelatedTo.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.Vector;


/**
 * iCalendar RELATED-TO property.
 *
 * <PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.8.4.5 [2445]
 *   occurs:	VEVENT, VTODO, VJOURNAL (0+)
 *   datatypes:	TEXT
 *   default:	---
 *   allowed:	---
 *   params:	RELTYPE(0-1), xparam(0+)
 * </PRE>
 *
 * @author  slh
 * @version  0.10 2003/04/15 slh
 */
public
class  RelatedTo
extends  TextProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a RELATED-TO property, unset.
   */
  public
  RelatedTo  (		)
  {
    super( getCalendarName(  ) );
  }


  /**
   * Create a RELATED-TO property set to supplied value.
   */
  public
  RelatedTo  (String	strValue	)
  {
    super( getCalendarName(  ) , strValue );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strProp_RelatedTo;
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  /**
   * Configures property by populating m_vParam*.
   */
  protected
  void
  configProperty  (		)
  {
    m_vParamZeroPlus = new Vector(  );
    /*void*/m_vParamZeroPlus.add( XParam.class );

    m_vParamZeroOne = new Vector(  );
    /*void*/m_vParamZeroOne.add( RelTypeParam.class );
  }

}


/* Log:
 *  0.10  2003/01/14, 2003/02/19, 2003/04/15  slh
 *        (new year, new version...)
 *        getCalendarName()
 *        configProperty()
 *  0.00  2002/11/05  slh
 *        create
 */
/*--RelatedTo.java----------------------------------------------------------*/
