/*++RelatedParam.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.HashMap;


/**
 * iCalendar RELATED parameter.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.2.14 [2445]
 *   occurs:	---
 *   datatypes:	TEXT (1)
 *   default:	"START"
 *   allowed:	"START", "END"
 *</PRE>
 *
 * @author  slh
 * @version  0.20 2003/02/19 slh
 */
public
class  RelatedParam
extends  EnumParam
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a RELATED parameter set to default.
   */
  public
  RelatedParam  (		)
  {
    super( getCalendarName(  ) );
  }


  /**
   * Create a RELATED parameter set to supplied string value.
   */
  public
  RelatedParam  (String	strValue	)
  {
    super( getCalendarName(  ) , strValue );
  }


  /**
   * Create a RELATED parameter set to supplied id value.
   */
  public
  RelatedParam  (int	iValue	)
  {
    super( getCalendarName(  ) , iValue );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strParam_Related;
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  /*Note: overriding EnumProp.configEnum()
    which is called in EnumProp.EnumProp(*).
  */
  protected
  void
  configEnum  (		)
  {
    m_hmValue = new HashMap(  );
    m_hmValue.put( new Integer( START ) , Names.strValue_Start );
    m_hmValue.put( new Integer( END ) , Names.strValue_End );

    m_strDefault = Names.strValue_Start;
  }


/*----------------------------------------------------------------------------
 *						Class Public Constants
 *--------------------------------------------------------------------------*/

  final static public  int	START		= 1;
  final static public  int	END		= 2;


/*----------------------------------------------------------------------------
 *						Main
 *--------------------------------------------------------------------------*/

  static public
  void  main  (String	argv[]	)
  {
    RelatedParam	relatedparam	= new RelatedParam(  );

    /*void*/System.out.println( relatedparam );

    try {
      /*void*/relatedparam.set( "START" );
      /*void*/System.out.println( relatedparam );

      /*void*/relatedparam.set( END );
      /*void*/System.out.println( relatedparam );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }

    /*void*/System.out.println( relatedparam.get(  ) );
    /*void*/System.out.println( relatedparam.getEnum(  ) );

    /*void*/System.out.println(
		"NOTE: should throw IllegalArgumentException:" );
    try {
      /*void*/relatedparam.set( 666 );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e );
    }
    /*void*/System.out.println(
		"NOTE: should throw IllegalArgumentException:" );
    try {
      /*void*/relatedparam.set( "six six six" );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e );
    }
    /*void*/System.out.println(
		"NOTE: should throw IllegalArgumentException:" );
    try {
      /*void*/relatedparam.set( "X-SLH-TRA" );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e );
    }

    /*void*/System.out.println( relatedparam );
  }

}


/* Log:
 *  0.20  2003/02/19  slh
 *        ch class name TrigRelParam -> RelatedParam
 *        getCalendarName()
 *  0.10  2003/02/05  slh
 *        (new year, new version...)
 *        configEnum(), etc
 *        redo constructors
 *  0.00  2002/11/05  slh
 *        create
 */
/*--RelatedParam.java-------------------------------------------------------*/
