/*++RelTypeParam.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.HashMap;


/**
 * iCalendar RELTYPE parameter.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.2.15 [2445]
 *   occurs:	---
 *   datatypes:	TEXT (1)
 *   default:	"PARENT"
 *   allowed:	"PARENT", "CHILD", "SIBLING", iana-token, x-name
 *</PRE>
 *
 * @author  slh
 * @version  0.10 2003/02/05 slh
 */
public
class  RelTypeParam
extends  EnumParam
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a RELTYPE parameter set to default.
   */
  public
  RelTypeParam  (		)
  {
    super( Names.strParam_RelType );
  }


  /**
   * Create a RELTYPE parameter set to supplied string value.
   */
  public
  RelTypeParam  (String	strValue	)
  {
    super( Names.strParam_RelType , strValue );
  }


  /**
   * Create a RELTYPE parameter set to supplied id value.
   */
  public
  RelTypeParam  (int	iValue	)
  {
    super( Names.strParam_RelType , iValue );
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  /*Note: overriding EnumProp.configEnum()
    which is called in EnumProp.EnumProp(*).
  */
  protected
  void
  configEnum  (		)
  {
    m_hmValue = new HashMap(  );
    m_hmValue.put( new Integer( PARENT ) , Names.strValue_Parent );
    m_hmValue.put( new Integer( CHILD ) , Names.strValue_Child );
    m_hmValue.put( new Integer( SIBLING ) , Names.strValue_Sibling );
    m_hmValue.put( new Integer( IANATOKEN ) , null );
    m_hmValue.put( new Integer( XNAME ) , null );

    m_strDefault = Names.strValue_Parent;
  }


/*----------------------------------------------------------------------------
 *						Class Public Constants
 *--------------------------------------------------------------------------*/

  final static public  int	PARENT		= 1;
  final static public  int	CHILD		= 2;
  final static public  int	SIBLING		= 3;


/*----------------------------------------------------------------------------
 *						Main
 *--------------------------------------------------------------------------*/

  static public
  void  main  (String	argv[]	)
  {
    RelTypeParam	reltypeparam		= new RelTypeParam(  );

    /*void*/System.out.println( reltypeparam );

    try {
      /*void*/reltypeparam.set( "CHILD" );
      /*void*/System.out.println( reltypeparam );

      /*void*/reltypeparam.set( SIBLING );
      /*void*/System.out.println( reltypeparam );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }

    /*void*/System.out.println( reltypeparam.get(  ) );
    /*void*/System.out.println( reltypeparam.getEnum(  ) );

    /*void*/System.out.println(
		"NOTE: should throw IllegalArgumentException:" );
    try {
      /*void*/reltypeparam.set( 666 );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e );
    }
    /*void*/System.out.println(
		"NOTE: should throw IllegalArgumentException:" );
    try {
      /*void*/reltypeparam.set( "six six six" );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e );
    }
    /*void*/System.out.println( reltypeparam );
  }

}


/* Log:
 *  0.10  2003/02/05  slh
 *        (new year, new version...)
 *        configEnum(), etc
 *        actually allow iana-token and x-name
 *        redo constructors
 *  0.00  2002/11/05  slh
 *        create
 */
/*--RelTypeParam.java-------------------------------------------------------*/
