/*++RecurrenceId.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.Vector;


/**
 * iCalendar RECURRENCE-ID property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.8.4.4 [2445]
 *   occurs:	VEVENT, VTODO, VJOURNAL (0-1)
 *   datatypes:	DATE-TIME, DATE (1)
 *   default:	---
 *   allowed:	---
 *   params:	VALUE(0-1)*, TZID(0-1), RANGE(0-1), xparam(0+)
 * * may be set implicitly
 *</PRE>
 *
 * Should be set to original value of DTSTART property (but can change).
 * If DTSTART type a DATE, then RECURRENCE-ID value represent that date.
 *
 * @author  slh
 * @version  0.20 2003/11/04 slh
 */
public
class  RecurrenceId
extends  TimeProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a RECURRENCE-ID property, unset.
   */
  public
  RecurrenceId  (		)
  {
    super( getCalendarName(  ) , DATETIME , false );
  }


  /**
   * Create a RECURRENCE-ID property set to supplied value.
   */
  protected
  RecurrenceId  (String	strValue	)
  {
    super( getCalendarName(  ) , strValue , DATETIME , false );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strProp_RecurrenceId;
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  void
  setType  (int		Type	)
  throws IllegalArgumentException
  {
    if (Type != DATETIME && Type != DATE) {
      throw new IllegalArgumentException( getName(  ) + ":setType()" +
		": type can only be DATE-TIME or DATE" );
    }

    /*void*/super.setType( Type );
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  protected
  void
  configProperty  (		)
  {
    m_vParamZeroPlus = new Vector(  );
    m_vParamZeroPlus.add( XParam.class );

    m_vParamZeroOne = new Vector(  );
    m_vParamZeroOne.add( ValueParam.class );
    m_vParamZeroOne.add( TZIDParam.class );
    m_vParamZeroOne.add( RangeParam.class );
  }

}


/* Log:
 *  0.20  2003/10/29, 2003/11/04  slh
 *        redo constructors; rm set()
 *        adjust for ValueTypeParam -> ValueParam
 *  0.10  2003/01/14, 2003/04/15  slh
 *        getCalendarName()
 *        configProperty()
 *  0.01  2002/03/05 - 2002/03/06  slh
 *        adjusted for new package location
 *        javadoc comments
 *  0.00  2002/02/27  slh
 *        create from DTStart
 */
/*--RecurrenceId.java-------------------------------------------------------*/
