/*++RangeParam.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.HashMap;


/**
 * iCalendar RANGE (recurrence identifier RANGE) parameter.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.2.13 [2445]
 *   occurs:	---
 *   datatypes:	TEXT (1)
 *   default:	---
 *   allowed:	"THISANDPRIOR", "THISANDFUTURE"
 *</PRE>
 *
 * @author  slh
 * @version  0.10 2003/10/21 slh
 */
public
class  RangeParam
extends  EnumParam
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a RANGE parameter, unset.
   */
  public
  RangeParam  (		)
  {
    super( getCalendarName(  ) );
  }


  /**
   * Create a RANGE parameter set to supplied string value.
   */
  public
  RangeParam  (String	strValue	)
  {
    super( getCalendarName(  ) , strValue );
  }


  /**
   * Create a RANGE parameter set to supplied id value.
   */
  public
  RangeParam  (int	iValue	)
  {
    super( getCalendarName(  ) , iValue );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strParam_Range;
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  /*Note: overriding EnumProp.configEnum()
    which is called in EnumProp.EnumProp(*).
  */
  protected
  void
  configEnum  (		)
  {
    m_hmValue = new HashMap(  );
    m_hmValue.put( new Integer( THISANDPRIOR ) ,
		   Names.strValue_ThisAndPrior );
    m_hmValue.put( new Integer( THISANDFUTURE ) ,
		   Names.strValue_ThisAndFuture );
  }


/*----------------------------------------------------------------------------
 *						Class Public Constants
 *--------------------------------------------------------------------------*/

  final static public  int	THISANDPRIOR	= 1;
  final static public  int	THISANDFUTURE	= 2;


/*----------------------------------------------------------------------------
 *						Main
 *--------------------------------------------------------------------------*/

  static public
  void  main  (String	argv[]	)
  {
    RangeParam	rangeparam	= new RangeParam(  );

    /*void*/System.out.println( rangeparam );

    try {
      /*void*/rangeparam.set( "THISANDPRIOR" );
      /*void*/System.out.println( rangeparam );

      /*void*/rangeparam.set( THISANDFUTURE );
      /*void*/System.out.println( rangeparam );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }

    /*void*/System.out.println( rangeparam.get(  ) );
    /*void*/System.out.println( rangeparam.getEnum(  ) );

    /*void*/System.out.println(
		"NOTE: should throw IllegalArgumentException:" );
    try {
      /*void*/rangeparam.set( 666 );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e );
    }
    /*void*/System.out.println(
		"NOTE: should throw IllegalArgumentException:" );
    try {
      /*void*/rangeparam.set( "six six six" );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e );
    }
    /*void*/System.out.println( rangeparam );
  }

}


/* Log:
 *  0.10  2003/10/21  slh
 *        derive from EnumParam (rather than UnsupParam) based on CUTypeParam
 *  0.01  2002/03/05 - 2002/03/06  slh
 *        adjusted for new package location
 *        javadoc comments
 *  0.00  2002/02/27  slh
 *        create from MemberParam
 */
/*--RangeParam.java---------------------------------------------------------*/
