/*++RSVPParam.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


/**
 * iCalendar RSVP (RSVP expectation) parameter.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.2.17 [2445]
 *   occurs:	<CAL-ADDRESS-valued properties> (1)
 *   datatypes:	BOOLEAN (1)
 *   default:	FALSE
 *   allowed:	---
 *</PRE>
 *
 * @author  slh
 * @version  0.00 2003/10/21 slh
 */
public
class  RSVPParam
extends  BooleanParam
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a RSVP parameter set to default.
   */
  public
  RSVPParam  (		)
  {
    super( getCalendarName(  ) );
  }


  /**
   * Create a RSVP parameter set to supplied value.
   */
  public
  RSVPParam  (String	strValue	)
  {
    super( getCalendarName(  ) , strValue );
  }


  /**
   * Create a RSVP parameter set to supplied value.
   */
  public
  RSVPParam  (int	iValue	)
  {
    super( getCalendarName(  ) , iValue );
  }


  /**
   * Create a RSVP parameter set to supplied value.
   */
  public
  RSVPParam  (boolean	bValue	)
  {
    super( getCalendarName(  ) , bValue );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strParam_RSVP;
  }
  
}


/* Log:
 *  0.10  2003/10/21  slh
 *        derive from BooleanParam (rather than UnsupParam)
 *  0.00  2001/05/15  slh
 *        create
 */
/*--RSVPParam.java----------------------------------------------------------*/
