/*++RDate.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.Vector;


/**
 * iCalendar RDATE property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 *   section:	4.8.5.3 [2445]
 *   occurs:	VEVENT, VTODO, VJOURNAL, VTIMEZONE (0+)
 *   datatypes:	DATE-TIME, DATE, PERIOD (1+)
 *   default:	---
 *   allowed:	---
 *   params:	VALUE(0-1), TZID(0-1), xparam(0+)
 *</PRE>
 *
 * @author  slh
 * @version  0.00 2003/10/29 slh
 */
public
class  RDate
extends  UnsupProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /*Note: attempting to use the default constructor is wrong*/


  /* this is the base constructor */
  /**
   * Create a RDATE property, unset.
   */
  public
  RDate  (		)
  {
    super( getCalendarName(  ) );
  }


  /**
   * Create a RDATE property set to supplied value.
   */
  public
  RDate  (String	strValue	)
  {
    super( getCalendarName(  ) , strValue );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strProp_RDate;
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  protected
  void
  configProperty  (		)
  {
    m_vParamZeroOne = new Vector(  );
    /*void*/m_vParamZeroOne.add( ValueParam.class );
    /*void*/m_vParamZeroOne.add( TZIDParam.class );

    m_vParamZeroPlus = new Vector(  );
    /*void*/m_vParamZeroPlus.add( XParam.class );
  }

}


/* Log:
 *  0.01  2003/10/29  slh
 *        sync with current paradigms
 *        adjust for ValueTypeParam -> ValueParam
 *  0.00  2003/02/12  slh
 *        create
 */
/*--RDate.java--------------------------------------------------------------*/
