/*++Property.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.Enumeration;
import  java.util.Vector;


/**
 * Base class for ICalendar properties.
 *
 * Subclassing:
 * Do implement abstract methods: set() and getString().
 * Do not implement toString() as one here will call getString().
 * Override configProperty() to create and populate m_vParam* with
 * the allowed parameters.
 * configProperty() will be called from all the constructors.
 *
 * @author  slh
 * @version  0.20 2003/04/23 slh
 */
abstract public
class  Property
implements  Collectible
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /*Note: attempting to use the default constructor is wrong*/


  protected
  Property  (String	strName	)
  {
    if (strName == null) {
      throw new NullPointerException( "Property.Property()" +
		": strName (String) is null" );
    }
    m_strName = strName;

    m_parameters = new Parameters(  );

    /*void*/configProperty(  );
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  String
  getName  (		)
  {
    return m_strName;
  }


  public
  boolean
  isComplete  (		)
  {
    Enumeration		enum;

    if ((m_vParamOne != null || m_vParamOnePlus != null) &&
	m_parameters.size(  ) == 0) {
      return false;						/*RETUNR*/
    }
    if (m_vParamOne != null) {
      for (enum = m_vParamOne.elements(  ) ;
	   enum.hasMoreElements(  ) ;  ) {
	if (1 != m_parameters.getCount(
			(java.lang.Class)enum.nextElement(  ) )) {
	  return false;						/*RETURN*/
	}
      }
    }
    if (m_vParamOnePlus != null) {
      for (enum = m_vParamOnePlus.elements(  ) ;
	   enum.hasMoreElements(  ) ;  ) {
	if (1 > m_parameters.getCount(
			(java.lang.Class)enum.nextElement(  ) )) {
	  return false;						/*RETURN*/
	}
      }
    }

    if (m_vParamZeroOne != null) {
      for (enum = m_vParamZeroOne.elements(  ) ;
	   enum.hasMoreElements(  ) ;  ) {
	if (1 < m_parameters.getCount(
			(java.lang.Class)enum.nextElement(  ) )) {
	  return false;						/*RETURN*/
	}
      }
    }

    return m_parameters.isComplete(  );				/*RETURN*/
  }


  public
  boolean
  isSupported  (		)
  {
    return m_parameters.isSupported(  );			/*RETURN*/
  }


  /**
   * Set property's value through a String.
   */
  abstract public
  void
  set  (String	strValue	)
  throws Exception;


  /**
   * @return
   * the parameters associated with this property.
   * Will never be null.
   */
  public
  Parameters
  getParameters  (		)
  {
    return m_parameters;
  }


  /**
   * Add a parameter to property.
   *
   * Adds parameter to this property
   * checking for parameter type and number.
   *
   * @exception	NullPointerException
   *   if parameter is null
   * @exception	InvalidParameterException
   *   if parameter type or number is not allowed
   */
  public
  void
  addParameter  (Parameter	parameter	)
  throws ICalendarException
  {
    if (parameter == null) {
      throw new NullPointerException( getName(  ) + ": addParameter()" +
		": parameter (Parameter) is null" );
    }

    if ((m_vParamOne == null ||
	 !ClassVector.contains( m_vParamOne , parameter.getClass(  ) )) &&
	(m_vParamOnePlus == null ||
	 !ClassVector.contains( m_vParamOnePlus , parameter.getClass(  ) )) &&
	(m_vParamZeroOne == null ||
	 !ClassVector.contains( m_vParamZeroOne , parameter.getClass(  ) )) &&
	(m_vParamZeroPlus == null ||
	 !ClassVector.contains( m_vParamZeroPlus , parameter.getClass(  ) ))) {
      throw new InvalidParameterException( getName(  ) + ": addParameter()" +
		": parameter not allowed: " + parameter.getName(  ) );
    }

    if (m_vParamOne != null &&
	ClassVector.contains( m_vParamOne , parameter.getClass(  ) ) &&
	0 != m_parameters.getCount( parameter.getClass(  ) ) ||
	m_vParamZeroOne != null &&
	ClassVector.contains( m_vParamZeroOne , parameter.getClass(  ) ) &&
	0 != m_parameters.getCount( parameter.getClass(  ) )) {
      throw new InvalidParameterException( getName(  ) + ": addParameter()" +
		": maximum of one instance allowed of parameter: " +
		parameter.getName(  ) );
    }

    /*void*/addAnyParameter( parameter );
  }


  /**
   * Return property's value as a String.
   */
  abstract public
  String
  getString  (		);


  public
  String
  toString  (		)
  {
    String	strValue	= getString(  );

    return m_strName + m_parameters + ":" +
		(strValue == null ? "" : strValue);
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  /**
   * allows subclasses to super.add
   */
  protected
  void
  addAnyParameter  (Parameter	parameter	)
  {
    if (parameter == null) {
      throw new NullPointerException( getName(  ) + ": addAnyParameter()" +
		": parameter (Parameter) is null" );
    }

    /*void*/m_parameters.put( parameter );
  }


  /**
   * Configures property by populating m_vParam*.
   */
  protected
  void
  configProperty  (		)
  {
    m_vParamZeroPlus = new Vector(  );
    /*void*/m_vParamZeroPlus.add( XParam.class );
  }


  protected
  void
  setupProperty  (		)
  throws InstantiationException, IllegalAccessException
  {
//???rm when all refs rm
  }


/*----------------------------------------------------------------------------
 *						Object Protected Variables
 *--------------------------------------------------------------------------*/

  /*Assert: m_strName never null after construction*/
  protected  String		m_strName		= null;
  /*Assert: m_parameters never null after construction*/
  protected  Parameters		m_parameters		= null;

  /**
   * Parameters that MUST occur exactly once.
   */
  protected  Vector		m_vParamOne		= null;
  /**
   * Parameters that MUST occur at least once and MAY occur more than once.
   */
  protected  Vector		m_vParamOnePlus		= null;
  /**
   * Parameters that are OPTIONAL but MAY NOT occur more than once.
   */
  protected  Vector		m_vParamZeroOne		= null;
  /**
   * Parameters that MAY occur more than once.
   */
  protected  Vector		m_vParamZeroPlus		= null;

}


/* Log:
 *  0.20  2003/01/08 ... 2003/02/12, 2003/04/16, 2003/04/23  slh
 *        (new year, new version...)
 *        (rm getClassMap(); start backing out setupProperty())
 *        addParameter(): use class to id members
 *        addParameter(): narrow throws from Exception
 *        getParameters(): rm throws ICalendarException
 *        use .class to get class
 *        getClassMap(), setupProperty(), m_hmNameToClass
 *  0.10  2002/12/04, 2002/12/10  slh
 *        getString(); toString() uses getString()
 *        implement ch in Collectible: isComplete(), isSupported()
 *        table driven
 *  0.02  2001/08/14  slh
 *        add: set(String)
 *  0.01  2001/05/21  slh
 *        m_parameters: instantiate in constructor
 *  0.00  2001/04/24 - 2001/04/25, 2001/05/01 ... 2001/05/14  slh
 *        create
 */
/*--Property.java-----------------------------------------------------------*/
