/*++Priority.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;



/**
 * Priority: ICalendar PRIORITY property.
 *
 * Spec:
 *   section:	4.8.1.9
 *   occurs:	0-1 (VEVENT,VTODO)
 *   datatypes:	INTEGER (1)
 *   default:	0 (== undefined)
 *   allowed:	0-9
 *   params:	xparam (0+)
 *
 * @author slh
 * @version 0.10 2002/11/06 slh
 */
public
class  Priority
extends  BoundedIntegerProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a PRIORITY property with default value.
   */
  /* this is the base constructor */
  public
  Priority  (		)
  {
    super( Names.strProp_Priority ,
	   new Integer( mc_Min ) , new Integer( mc_Max ) );

    /*Note:
      may be immediately changed if being called by another constructor*/
    /*void*/set( mc_Default );
  }


  /**
   * Create a PRIORITY property with indicated value.
   */
  public
  Priority  (String	strValue	)
  {
    this(  );

    /*void*/set( strValue );
  }


  /**
   * Create a PRIORITY property with indicated value.
   */
  public
  Priority  (Integer	IValue	)
  {
    this(  );

    /*void*/set( IValue );
  }


  /**
   * Create a PRIORITY property with indicated value.
   */
  public
  Priority  (int	iValue	)
  {
    this(  );

    /*void*/set( iValue );
  }


/*----------------------------------------------------------------------------
 *						Class Public Constants
 *--------------------------------------------------------------------------*/

  final static public  int	mc_Min		= 0;
  final static public  int	mc_Max		= 9;
  final static public  int	mc_Default	= 0;


/*----------------------------------------------------------------------------
 *						Main
 *--------------------------------------------------------------------------*/

  static public
  void  main  (String	argv[]	)
  {
    Priority	priority	= new Priority(  );
    XParam	xparam;

    /*void*/System.out.println( priority );

    /*void*/priority.set( 9 );
    /*void*/System.out.println( priority );

    try {
      xparam = new XParam( "X-CAC-XXX" , "yyy" );
      /*void*/priority.addParameter( xparam );
      /*void*/System.out.println( priority );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }

    try {
      /*void*/System.out.println( priority.get(  ) );
    } catch (ICalendarException	e	) {
      /*void*/e.printStackTrace(  );
    }

    /*void*/System.out.println(
		"NOTE: should throw IllegalArgumentException:" );
    try {
      /*void*/priority.set( -1 );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e.getLocalizedMessage(  ) );
    }
    /*void*/System.out.println(
		"NOTE: should throw IllegalArgumentException:" );
    try {
      /*void*/priority.set( 10 );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e.getLocalizedMessage(  ) );
    }
    /*void*/System.out.println( priority );
  }

}


/* Log:
 *  0.10  2002/10/30, 2002/11/06  slh
 *        derive from BoundedIntegerProp (instead of IntProp)
 *        Priority(String), Priority(Integer), Priority(int)
 *  0.01  2001/05/17  slh
 *        rm unnec throws decl
 *        adjust for change in XParam
 *  0.00  2001/04/25, 2001/05/02  slh
 *        create
 */
/*--Priority.java-----------------------------------------------------------*/
