/*++PercentComplete.java++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


/**
 * ICalendar PERCENT-COMPLETE property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.8.1.8
 *   occurs:	0-1 (VTODO)
 *   datatypes:	INTEGER (1)
 *   default:	---
 *   allowed:	0-100
 *   params:	xparam (0+)
 *</PRE>
 *
 * @author slh
 * @version 0.00 2002/11/06 slh
 */
public
class  PercentComplete
extends  BoundedIntegerProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a PERCENT-COMPLETE property unset.
   */
  /* this is the base constructor */
  public
  PercentComplete  (		)
  {
    super( Names.strProp_PercentComplete ,
	   new Integer( mc_Min ) , new Integer( mc_Max ) );
  }


  /**
   * Create a PERCENT-COMPLETE property with indicated value.
   */
  public
  PercentComplete  (String	strValue	)
  {
    this(  );

    /*void*/set( strValue );
  }


  /**
   * Create a PERCENT-COMPLETE property with indicated value.
   */
  public
  PercentComplete  (Integer	IValue	)
  {
    this(  );

    /*void*/set( IValue );
  }


  /**
   * Create a PERCENT-COMPLETE property with indicated value.
   */
  public
  PercentComplete  (int	iValue	)
  {
    this(  );

    /*void*/set( iValue );
  }


/*----------------------------------------------------------------------------
 *						Class Public Constants
 *--------------------------------------------------------------------------*/

  final static public  int	mc_Min		= 0;
  final static public  int	mc_Max		= 100;


/*----------------------------------------------------------------------------
 *						Main
 *--------------------------------------------------------------------------*/

  static public
  void  main  (String	argv[]	)
  {
    PercentComplete	percentcomplete		= new PercentComplete(  );
    XParam	xparam;

    /*void*/System.out.println( percentcomplete );

    /*void*/percentcomplete.set( 9 );
    /*void*/System.out.println( percentcomplete );

    try {
      xparam = new XParam( "X-CAC-XXX" , "yyy" );
      /*void*/percentcomplete.addParameter( xparam );
      /*void*/System.out.println( percentcomplete );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }

    try {
      /*void*/System.out.println( percentcomplete.get(  ) );
    } catch (ICalendarException	e	) {
      /*void*/e.printStackTrace(  );
    }

    /*void*/System.out.println(
		"NOTE: should throw IllegalArgumentException:" );
    try {
      /*void*/percentcomplete.set( -1 );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e.getLocalizedMessage(  ) );
    }
    /*void*/System.out.println(
		"NOTE: should throw IllegalArgumentException:" );
    try {
      /*void*/percentcomplete.set( 101 );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e.getLocalizedMessage(  ) );
    }
    /*void*/System.out.println( percentcomplete );
  }

}


/* Log:
 *  0.00  2002/11/06  slh
 *        create from Priority
 */
/*--PercentComplete.java----------------------------------------------------*/
