/*++PartStatParam.java++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.HashMap;


/**
 * iCalendar PARTSTAT (PARTicipation STATus) parameter.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.2.12 [2445]
 *   occurs:	<CAL-ADDRESS-valued properties in VEVENT, VTODO, VJOURNAL> (1)
 *   datatypes:	TEXT (1)
 *   default:	"NEEDS-ACTION"
 *   allowed:	varies by containing component
 *     union	"NEEDS-ACTION", "ACCEPTED", "DECLINED",
 *		"TENTATIVE", "DELEGATED", "COMPLETED", "IN-PROCESS",
 *		iana-token, x-name
 *     common	"NEEDS-ACTION", "ACCEPTED", "DECLINED", iana-token, x-name
 *     VEVENT	"TENTATIVE", "DELEGATED"
 *     VTODO	"TENTATIVE", "DELEGATED", "COMPLETED", "IN-PROCESS"
 *     JOURNAL	---
 *</PRE>
 *
 * @author  slh
 * @version  0.10 2003/10/21 slh
 */
public
class  PartStatParam
extends  EnumParam
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a PARTSTAT parameter set to default.
   */
  public
  PartStatParam  (		)
  {
    super( getCalendarName(  ) );
  }


  /**
   * Create a PARTSTAT parameter set to supplied string value.
   */
  public
  PartStatParam  (String	strValue	)
  {
    super( getCalendarName(  ) , strValue );
  }


  /**
   * Create a PARTSTAT parameter set to supplied id value.
   */
  public
  PartStatParam  (int	iValue	)
  {
    super( getCalendarName(  ) , iValue );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strParam_PartStat;
  }

/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

//???should be used in an isComplete() that checks container's container
  /**
   * Determines if parameter is complete when property of which it is part
   * is contained in the indicated component.
   */
  public
  boolean
  isComplete  (Component	compContaining	)
  {
    java.lang.Class	jlclass;

    if (compContaining == null) {
      return isComplete(  );					/*RETURN*/
    }

    jlclass = compContaining.getClass(  );

   /* common */
    switch (m_iValue) {
    case NEEDSACTION:
    case ACCEPTED:
    case DECLINED:
    case IANATOKEN:
    case XNAME:
      return isComplete(  );					/*RETURN*/
    }

    if        (VEvent.class.isAssignableFrom( jlclass )) {
      switch (m_iValue) {
      case TENTATIVE:
      case DELEGATED:
	break;
      default:
	return false;						/*RETURN*/
      }
    } else if (VTodo.class.isAssignableFrom( jlclass )) {
      switch (m_iValue) {
      case TENTATIVE:
      case DELEGATED:
      case COMPLETED:
      case INPROCESS:
	break;
      default:
	return false;						/*RETURN*/
      }
    } else if (VJournal.class.isAssignableFrom( jlclass )) {
      return false;						/*RETURN*/
    } else {
      return false;						/*RETURN*/
    }

   /* component-specific checks ok */
    return isComplete(  );					/*RETURN*/
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  /*Note: overriding EnumProp.configEnum()
    which is called in EnumProp.EnumProp(*).
  */
  protected
  void
  configEnum  (		)
  {
    m_hmValue = new HashMap(  );
    m_hmValue.put( new Integer( NEEDSACTION ) , Names.strValue_NeedsAction );
    m_hmValue.put( new Integer( ACCEPTED ) , Names.strValue_Accepted );
    m_hmValue.put( new Integer( DECLINED ) , Names.strValue_Declined );
    m_hmValue.put( new Integer( TENTATIVE ) , Names.strValue_Tentative );
    m_hmValue.put( new Integer( DELEGATED ) , Names.strValue_Delegated );
    m_hmValue.put( new Integer( COMPLETED ) , Names.strValue_Completed );
    m_hmValue.put( new Integer( INPROCESS ) , Names.strValue_InProcess );
    m_hmValue.put( new Integer( IANATOKEN ) , null );
    m_hmValue.put( new Integer( XNAME ) , null );

    m_strDefault = Names.strValue_NeedsAction;
  }


/*----------------------------------------------------------------------------
 *						Class Public Constants
 *--------------------------------------------------------------------------*/

  final static public  int	NEEDSACTION	= 1;
  final static public  int	ACCEPTED	= 2;
  final static public  int	DECLINED	= 3;
  final static public  int	TENTATIVE	= 4;
  final static public  int	DELEGATED	= 5;
  final static public  int	COMPLETED	= 6;
  final static public  int	INPROCESS	= 7;


/*----------------------------------------------------------------------------
 *						Main
 *--------------------------------------------------------------------------*/

  static public
  void  main  (String	argv[]	)
  {
    PartStatParam	partstatparam	= new PartStatParam(  );

    /*void*/System.out.println( partstatparam );

    try {
      /*void*/partstatparam.set( "ACCEPTED" );
      /*void*/System.out.println( partstatparam );

      /*void*/partstatparam.set( DECLINED );
      /*void*/System.out.println( partstatparam );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }

    /*void*/System.out.println( partstatparam.get(  ) );
    /*void*/System.out.println( partstatparam.getEnum(  ) );

    /*void*/System.out.println(
		"NOTE: should throw IllegalArgumentException:" );
    try {
      /*void*/partstatparam.set( 666 );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e );
    }
    /*void*/System.out.println(
		"NOTE: should throw IllegalArgumentException:" );
    try {
      /*void*/partstatparam.set( "six six six" );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e );
    }
    /*void*/System.out.println( partstatparam );

    try {
      /*void*/partstatparam.set( COMPLETED );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }
    /*void*/System.out.println( partstatparam.isComplete( new VEvent(  ) ) );
    /*void*/System.out.println( partstatparam.isComplete( new VTodo(  ) ) );
    /*void*/System.out.println(
		partstatparam.isComplete( new VJournal(  ) ) );
  }

}


/* Log:
 *  0.10  2003/10/21  slh
 *        derive from EnumParam (rather than UnsupParam) based on CUTypeParam
 *  0.00  2001/05/15  slh
 *        create
 */
/*--PartStatParam.java------------------------------------------------------*/
