/*++Parameter.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


/**
 * Base class for iCalendar parameters.
 *
 * Subclassing:
 * Do implement abstract methods: set() and getString().
 * Do not implement toString() as one here will call getString().
 *
 * @author  slh
 * @version  0.10 2002/12/10 slh
 */
abstract public
class  Parameter
implements  Collectible
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /*Note: attempting to use the default constructor is wrong*/


  protected
  Parameter  (String	strName	)
  {
    if (strName == null) {
      throw new NullPointerException(
		"Parameter: strName (String) is null" );
    }
    m_strName = strName;
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  String
  getName  (		)
  {
    return m_strName;
  }


  public
  boolean
  isComplete  (		)
  {
    return true;
  }


  public
  boolean
  isSupported  (		)
  {
    return true;
  }


  /**
   * Set parameter's value through a String.
   */
  abstract public
  void
  set  (String	strValue	)
  throws Exception;


  /**
   * Return parameter's value as a String.
   */
  abstract public
  String
  getString  (		);


  public
  String
  toString  (		)
  {
    String	strValue	= getString(  );

    return m_strName + "=" + (strValue == null ? "" : strValue);
  }


/*----------------------------------------------------------------------------
 *						Object Protected Variables
 *--------------------------------------------------------------------------*/

  protected  String	m_strName	= null;

}


/* Log:
 *  0.10  2002/12/04, 2002/12/10  slh
 *        getString(); toString() uses getString()
 *        implement ch in Collectible: isComplete(), isSupported()
 *  0.01  2001/08/14  slh
 *        add: set(String)
 *  0.00  2001/04/25, 2001/05/02  slh
 *        create
 */
/*--Parameter.java----------------------------------------------------------*/
