/*++Organizer.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.Vector;


/**
 * iCalendar ORGANIZER property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.8.4.3 [2445]
 *   occurs:	VEVENT (0-1)
 *   datatypes:	CAL-ADDRESS (1)
 *   default:	---
 *   allowed:	---
 *   params:	CN(0-1), DIR(0-1), SENTBY(0-1), LANGUAGE(0-1), xparam(0+)
 *</PRE>
 *
 * @author  slh
 * @version  0.10 2003/04/15 slh
 */
public
class  Organizer
extends  CalAddressProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a ORGANIZER property, unset.
   */
  public
  Organizer  (		)
  {
    super( getCalendarName(  ) );
  }


  /**
   * Create a ORGANIZER property set to supplied value.
   */
  public
  Organizer  (String	strValue	)
  {
    super( getCalendarName(  ) );

    try {
      /*void*/set( strValue );
    } catch (IllegalArgumentException	e	) {
      throw e;
    } catch (Exception	e	) {
      throw new IllegalArgumentException( getName(  ) + ": " + e );
    }
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strProp_Organizer;
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  /**
   * Configures property by populating m_vParam*.
   */
  protected
  void
  configProperty  (		)
  {
    m_vParamZeroPlus = new Vector(  );
    m_vParamZeroPlus.add( XParam.class );

    m_vParamZeroOne = new Vector(  );
    m_vParamZeroOne.add( CNParam.class );
    m_vParamZeroOne.add( DirParam.class );
    m_vParamZeroOne.add( SentByParam.class );
    m_vParamZeroOne.add( LanguageParam.class );
  }


/*----------------------------------------------------------------------------
 *						Main
 *--------------------------------------------------------------------------*/

  static public
  void  main  (String	argv[]	)
  {
    Organizer	organizer	= new Organizer(  );
    XParam	xparam		= new XParam( "X-ekuk-zzz" );
    AltRepParam	altrepparam	= new AltRepParam(  );
    SentByParam	sentbyparam	= new SentByParam(  );

    /*void*/System.out.println( organizer );

    try {
      /*void*/organizer.set( "MAILTO:slh@www.ekuk.org" );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }
    /*void*/System.out.println( organizer );

    try {
      /*void*/xparam.set( "now" );
      /*void*/organizer.addParameter( xparam );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }
    /*void*/System.out.println( organizer );

    /*void*/System.out.println(
		"NOTE: should throw InvalidParameterException:" );
    try {
      /*void*/altrepparam.set( "ALTREP:none" );
      /*void*/organizer.addParameter( altrepparam );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e );
    }
    /*void*/System.out.println( organizer );

    try {
      /*void*/sentbyparam.set( "SENTBY:me" );
      /*void*/organizer.addParameter( sentbyparam );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }
    /*void*/System.out.println( organizer );
    /*void*/System.out.println(
		"NOTE: should throw InvalidParameterException:" );
    try {
      /*void*/organizer.addParameter( sentbyparam );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e );
    }
    /*void*/System.out.println( organizer );

    /*void*/System.out.println(
		"NOTE: should throw InvalidParameterException:" );
    try {
      /*void*/organizer.set( "http://www.ekuk.org" );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e );
    }
    /*void*/System.out.println( organizer );
  }

}


/* Log:
 *  0.10  2003/01/14, 2003/04/15  slh
 *        getCalendarName()
 *        configProperty()
 *  0.00  2001/05/14 - 2001/05/15  slh
 *        create
 */
/*--Organizer.java----------------------------------------------------------*/
