/*++NonnegativeIntegerProp.java+++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


/**
 * Base class for nonnegative INTEGER-valued properties.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	derived from 4.3.8 Integer
 *   allowed:	---
 *</PRE>
 *
 * @author slh
 * @version 0.00 2002/11/06 slh
 */
abstract public
class  NonnegativeIntegerProp
extends  BoundedIntegerProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /*Note: attempting to use the default constructor is wrong*/


  /**
   * Create a NonnegativeInteger property unset.
   */
  /* this is the base constructor */
  public
  NonnegativeIntegerProp  (String	strName	)
  {
    super( strName , new Integer( 0 ) , null );
  }


  /**
   * Create a NonnegativeInteger property set to indicated value.
   */
  public
  NonnegativeIntegerProp  (String	strName		,
			   String	strValue	)
  {
    this( strName );

    /*void*/set( strValue );
  }


  /**
   * Create a NonnegativeInteger property set to indicated value.
   */
  public
  NonnegativeIntegerProp  (String	strName	,
			   Integer	IValue	)
  {
    this( strName );

    /*void*/set( IValue );
  }


  /**
   * Create a NonnegativeInteger property set to indicated value.
   */
  public
  NonnegativeIntegerProp  (String	strName	,
			   int		iValue	)
  {
    this( strName );

    /*void*/set( iValue );
  }

}


/* Log:
 *  0.00  2002/10/30, 2002/11/06  slh
 *        create from
 */
/*--NonnegativeIntegerProp.java---------------------------------------------*/
