/*++NonnegativeIntegerParam.java++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


/**
 * Base class for nonnegative INTEGER-valued parameters.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	derived from 4.3.8 Integer
 *   allowed:	---
 *</PRE>
 *
 * @author slh
 * @version 0.00 2002/11/06 slh
 */
abstract public
class  NonnegativeIntegerParam
extends  BoundedIntegerParam
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /*Note: attempting to use the default constructor is wrong*/


  /**
   * Create a NonnegativeInteger parameter unset.
   */
  /* this is the base constructor */
  public
  NonnegativeIntegerParam  (String	strName	)
  {
    super( strName , new Integer( 0 ) , null );
  }


  /**
   * Create a NonnegativeInteger parameter set to indicated value.
   */
  public
  NonnegativeIntegerParam  (String	strName		,
			    String	strValue	)
  {
    this( strName );

    /*void*/set( strValue );
  }


  /**
   * Create a NonnegativeInteger parameter set to indicated value.
   */
  public
  NonnegativeIntegerParam  (String	strName	,
			    Integer	IValue	)
  {
    this( strName );

    /*void*/set( IValue );
  }


  /**
   * Create a NonnegativeInteger parameter set to indicated value.
   */
  public
  NonnegativeIntegerParam  (String	strName	,
			   int		iValue	)
  {
    this( strName );

    /*void*/set( iValue );
  }

}


/* Log:
 *  0.00  2002/10/30  slh
 *        create
 */
/*--NonnegativeIntegerParam.java--------------------------------------------*/
