/*++NaturalNumberProp.java++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


/**
 * Base class for natural number INTEGER-valued properties.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	derived from 4.3.8 Integer
 *   allowed:	---
 *</PRE>
 *
 * @author slh
 * @version 0.00 2002/11/06 slh
 */
abstract public
class  NaturalNumberProp
extends  BoundedIntegerProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /*Note: attempting to use the default constructor is wrong*/


  /**
   * Create a NaturalNumber property unset.
   */
  /* this is the base constructor */
  public
  NaturalNumberProp  (String	strName	)
  {
    super( strName , new Integer( 1 ) , null );
  }


  /**
   * Create a NaturalNumber property set to indicated value.
   */
  public
  NaturalNumberProp  (String	strName		,
		      String	strValue	)
  {
    this( strName );

    /*void*/set( strValue );
  }


  /**
   * Create a NaturalNumber property set to indicated value.
   */
  public
  NaturalNumberProp  (String	strName	,
		      Integer	IValue	)
  {
    this( strName );

    /*void*/set( IValue );
  }


  /**
   * Create a NaturalNumber property set to indicated value.
   */
  public
  NaturalNumberProp  (String	strName	,
		      int	iValue	)
  {
    this( strName );

    /*void*/set( iValue );
  }

}


/* Log:
 *  0.00  2002/10/30, 2002/11/06  slh
 *        create
 */
/*--NaturalNumberProp.java--------------------------------------------------*/
