/*++NaturalNumberParam.java+++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


/**
 * Base class for natural number INTEGER-valued parameters.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	derived from 4.3.8 Integer
 *   allowed:	---
 *</PRE>
 *
 * @author slh
 * @version 0.00 2002/11/06 slh
 */
abstract public
class  NaturalNumberParam
extends  BoundedIntegerParam
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /*Note: attempting to use the default constructor is wrong*/


  /**
   * Create a NaturalNumber parameter unset.
   */
  /* this is the base constructor */
  public
  NaturalNumberParam  (String	strName	)
  {
    super( strName , new Integer( 1 ) , null );
  }


  /**
   * Create a NaturalNumber parameter set to indicated value.
   */
  public
  NaturalNumberParam  (String	strName		,
		       String	strValue	)
  {
    this( strName );

    /*void*/set( strValue );
  }


  /**
   * Create a NaturalNumber parameter set to indicated value.
   */
  public
  NaturalNumberParam  (String	strName	,
		       Integer	IValue	)
  {
    this( strName );

    /*void*/set( IValue );
  }


  /**
   * Create a NaturalNumber parameter set to indicated value.
   */
  public
  NaturalNumberParam  (String	strName	,
		       int	iValue	)
  {
    this( strName );

    /*void*/set( iValue );
  }

}


/* Log:
 *  0.00  2002/10/30, 2002/11/06  slh
 *        create
 */
/*--NaturalNumberParam.java-------------------------------------------------*/
