/*++Names.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


/**
 * iCalendar component, property and parameter names and values.
 *
 * @author  slh
 * @version  0.06 2003/10/29 slh
 */
abstract public
class  Names
{

/*----------------------------------------------------------------------------
 *						Class Public Constants
 *--------------------------------------------------------------------------*/

  /* 4.2 Property Parameters */
  final static public  String	strParam_AltRep		= "ALTREP";
  final static public  String	strParam_CN		= "CN";
  final static public  String	strParam_CUType		= "CUTYPE";
  final static public  String	strParam_DelFrom	= "DELFROM";
  final static public  String	strParam_DelTo		= "DELTO";
  final static public  String	strParam_Dir		= "DIR";
  final static public  String	strParam_Encoding	= "ENCODING";
  final static public  String	strParam_FmtType	= "FMTTYPE";
  final static public  String	strParam_FBType		= "FBTYPE";
  final static public  String	strParam_Language	= "LANGUAGE";
  final static public  String	strParam_Member		= "MEMBER";
  final static public  String	strParam_PartStat	= "PARTSTAT";
  final static public  String	strParam_Range		= "RANGE";
  final static public  String	strParam_Related	= "RELATED";
  final static public  String	strParam_RelType	= "RELTYPE";
  final static public  String	strParam_Role		= "ROLE";
  final static public  String	strParam_RSVP		= "RSVP";
  final static public  String	strParam_SentBy		= "SENTBY";
  final static public  String	strParam_TZID		= "TZID";
  final static public  String	strParam_Value		= "VALUE";
  /* not real names, but now defined in one place */
  final static public  String	strParam_IANA		= "ianaparam";
  final static public  String	strParam_X		= "xparam";
  /* even less of a real name */
  final static public  String	strParam_Unsupported	= "unsupparam";

  /* 4.2.3 Calendar User Type */
  final static public  String	strValue_Individual	= "INDIVIDUAL";
  final static public  String	strValue_Group		= "GROUP";
  final static public  String	strValue_Resource	= "RESOURCE";
  final static public  String	strValue_Room		= "ROOM";
  final static public  String	strValue_Unknown	= "UNKNOWN";
  /* 4.2.7 Inline Encoding */
  final static public  String	strValue_8Bit		= "8BIT";
  final static public  String	strValue_Base64		= "BASE64";
  /* iana-token */
  /* x-name */
  /* 4.2.8 Format Type */
  /* iana-token */
  /* x-name */
  /* 4.2.9 Free/Busy Time Type */
  final static public  String	strValue_Free		= "FREE";
  final static public  String	strValue_Busy		= "BUSY";
  final static public  String	strValue_BusyUnavailable	=
							"BUSY-UNAVAILABLE";
  final static public  String	strValue_BusyTentative	= "BUSY-TENTATIVE";
  /* iana-token */
  /* x-name */
  /* 4.2.12 Participation Status */
  /* (for VEVENT:) */
  final static public  String	strValue_NeedsAction	= "NEEDS-ACTION";
  final static public  String	strValue_Accepted	= "ACCEPTED";
  final static public  String	strValue_Declined	= "DECLINED";
  final static public  String	strValue_Tentative	= "TENTATIVE";
  final static public  String	strValue_Delegated	= "DELEGATED";
  /* iana-token */
  /* x-name */
  /* (for VTODO:) */
/*already defined
  final static public  String	strValue_NeedsAction	= "NEEDS-ACTION";
  final static public  String	strValue_Accepted	= "ACCEPTED";
  final static public  String	strValue_Declined	= "DECLINED";
  final static public  String	strValue_Tentative	= "TENTATIVE";
  final static public  String	strValue_Delegated	= "DELEGATED";
*/
  final static public  String	strValue_Completed	= "COMPLETED";
  final static public  String	strValue_InProcess	= "IN-PROCESS";
  /* iana-token */
  /* x-name */
  /* (for VJOURNAL:) */
/*already defined
  final static public  String	strValue_NeedsAction	= "NEEDS-ACTION";
  final static public  String	strValue_Accepted	= "ACCEPTED";
  final static public  String	strValue_Declined	= "DECLINED";
*/
  /* iana-token */
  /* x-name */
  /* 4.2.13  Recurrence Identifier Range */
  final static public  String	strValue_ThisAndPrior	= "THISANDPRIOR";
  final static public  String	strValue_ThisAndFuture	= "THISANDFUTURE";
  /* 4.2.14 Alarm Trigger Relationship */
  final static public  String	strValue_Start		= "START";
  final static public  String	strValue_End		= "END";
  /* 4.2.15 Relationship Type */
  final static public  String	strValue_Parent		= "PARENT";
  final static public  String	strValue_Child		= "CHILD";
  final static public  String	strValue_Sibling	= "SIBLING";
  /* iana-token */
  /* x-name */
  /* 4.2.16 Participation Role */
  final static public  String	strValue_Chair		= "CHAIR";
  final static public  String	strValue_ReqParticipant	= "REQ-PARTICIPANT";
  final static public  String	strValue_OptParticipant	= "OPT-PARTICIPANT";
  final static public  String	strValue_NonParticipant	= "NON-PARTICIPANT";
  /* iana-token */
  /* x-name */
  /* 4.2.20 Value Data Types */
  final static public  String	strValue_Binary		= "BINARY";
  final static public  String	strValue_Boolean	= "BOOLEAN";
  final static public  String	strValue_CalAddress	= "CAL-ADDRESS";
  final static public  String	strValue_Date		= "DATE";
  final static public  String	strValue_DateTime	= "DATE-TIME";
  final static public  String	strValue_Duration	= "DURATION";
  final static public  String	strValue_Float		= "FLOAT";
  final static public  String	strValue_Integer	= "INTEGER";
  final static public  String	strValue_Period		= "PERIOD";
  final static public  String	strValue_Recur		= "RECUR";
  final static public  String	strValue_Text		= "TEXT";
  final static public  String	strValue_Time		= "TIME";
  final static public  String	strValue_URI		= "URI";
  final static public  String	strValue_UTCOffset	= "UTC-OFFSET";
  /* iana-token */
  /* x-name */

  /* 4.3.2   Boolean */
  final static public  String	strValue_True		= "TRUE";
  final static public  String	strValue_False		= "FALSE";

  /* 4.4 iCalendar Object */
  final static public  String	strVCalendar		= "VCALENDAR";

  /* 4.6 Calendar Components (.1 - .6) */
  final static public  String	strComp_VEvent		= "VEVENT";
  final static public  String	strComp_VTodo		= "VTODO";
  final static public  String	strComp_VJournal	= "VJOURNAL";
  final static public  String	strComp_VFreeBusy	= "VFREEBUSY";
  final static public  String	strComp_VTimeZone	= "VTIMEZONE";
  final static public  String	strComp_VAlarm		= "VALARM";
  /* not real names, but now defined in one place */
  final static public  String	strComp_IANA		= "iana-comp";
  final static public  String	strComp_X		= "x-comp";
  /* even less of a real name */
  final static public  String	strComp_Unsupported	= "unsup-comp";

  /* 4.7 Calendar Properties (.1 - .4) */
  final static public  String	strProp_CalScale	= "CALSCALE";
  final static public  String	strProp_Method		= "METHOD";
  final static public  String	strProp_ProdId		= "PRODID";
  final static public  String	strProp_Version		= "VERSION";

  /* 4.8.1 Descriptive Component Properties (.1 - .12) */
  final static public  String	strProp_Attach		= "ATTACH";
  final static public  String	strProp_Categories	= "CATEGORIES";
  final static public  String	strProp_Class		= "CLASS";
  final static public  String	strProp_Comment		= "COMMENT";
  final static public  String	strProp_Description	= "DESCRIPTION";
  final static public  String	strProp_Geo		= "GEO";
  final static public  String	strProp_Location	= "LOCATION";
  final static public  String	strProp_PercentComplete	= "PERCENT-COMPLETE";
  final static public  String	strProp_Priority	= "PRIORITY";
  final static public  String	strProp_Resources	= "RESOURCES";
  final static public  String	strProp_Status		= "STATUS";
  final static public  String	strProp_Summary		= "SUMMARY";
  /* 4.8.2 Date and Time Component Properties (.1 - .7) */
  final static public  String	strProp_Completed	= "COMPLETED";
  final static public  String	strProp_DTEnd		= "DTEND";
  final static public  String	strProp_Due		= "DUE";
  final static public  String	strProp_DTStart		= "DTSTART";
  final static public  String	strProp_Duration	= "DURATION";
  final static public  String	strProp_FreeBusy	= "FREEBUSY";
  final static public  String	strProp_Transp		= "TRANSP";
  /* 4.8.3 Time Zone Component Properties (.1 - .5) */
  final static public  String	strProp_TZID		= "TZID";
  final static public  String	strProp_TZName		= "TZNAME";
  final static public  String	strProp_TZOffsetFrom	= "TZOFFSETFROM";
  final static public  String	strProp_TZOffsetTo	= "TZOFFSETTO";
  final static public  String	strProp_TZURL		= "TZURL";
  /* 4.8.4 Relationship Component Properties (.1 - .7) */
  final static public  String	strProp_Attendee	= "ATTENDEE";
  final static public  String	strProp_Contact		= "CONTACT";
  final static public  String	strProp_Organizer	= "ORGANIZER";
  final static public  String	strProp_RecurrenceId	= "RECURRENCE-ID";
  final static public  String	strProp_RelatedTo	= "RELATED-TO";
  final static public  String	strProp_URL		= "URL";
  final static public  String	strProp_UID		= "UID";
  /* 4.8.5 Recurrence Component Properties (.1 - .4) */
  final static public  String	strProp_ExDate		= "EXDATE";
  final static public  String	strProp_ExRule		= "EXRULE";
  final static public  String	strProp_RDate		= "RDATE";
  final static public  String	strProp_RRule		= "RRULE";
  /* 4.8.6 Alarm Component Properties (.1 - .3) */
  final static public  String	strProp_Action		= "ACTION";
  final static public  String	strProp_Repeat		= "REPEAT";
  final static public  String	strProp_Trigger		= "TRIGGER";
  /* 4.8.7 Change Management Component Properties (.1 - .4) */
  final static public  String	strProp_Created		= "CREATED";
  final static public  String	strProp_DTStamp		= "DTSTAMP";
  final static public  String	strProp_LastModified	= "LAST-MODIFIED";
  final static public  String	strProp_Sequence	= "SEQUENCE";
  /* 4.8.8 Miscellaneous Component Properties (.1 - .2) */
  /* not real names, but now defined in one place */
  final static public  String	strProp_IANA		= "iana-prop";
  final static public  String	strProp_X		= "x-prop";
  /* even less of a real name */
  final static public  String	strProp_Unsupported	= "unsup-prop";
  final static public  String	strProp_RequestStatus	= "REQUEST-STATUS";

  /* 4.7.1 Calendar Scale */
  final static public  String	strValue_Gregorian	= "GREGORIAN";
  /* iana-token */
  /* 4.7.2 Method */
  /* iana-token */
  /* 4.8.1.3 Classification */
  final static public  String	strValue_Public		= "PUBLIC";
  final static public  String	strValue_Private	= "PRIVATE";
  final static public  String	strValue_Confidential	= "CONFIDENTIAL";
  /* iana-token */
  /* x-name */
  /* 4.8.1.11 Status */
  /* (for VEVENT:) */
/*already defined
  final static public  String	strValue_Tentative	= "TENTATIVE";
*/
  final static public  String	strValue_Confirmed	= "CONFIRMED";
  final static public  String	strValue_Cancelled	= "CANCELLED";
  /* (for VTODO:) */
/*
  final static public  String	strValue_NeedsAction	= "NEEDS-ACTION";
  final static public  String	strValue_Completed	= "COMPLETED";
  final static public  String	strValue_InProcess	= "IN-PROCESS";
  final static public  String	strValue_Cancelled	= "CANCELLED";
*/
  /* (for VJOURNAL:) */
  final static public  String	strValue_Draft		= "DRAFT";
  final static public  String	strValue_Final		= "FINAL";
/*already defined
  final static public  String	strValue_Cancelled	= "CANCELLED";
*/
  /* 4.8.2.7 Time Transparency */
  final static public  String	strValue_Opaque		= "OPAQUE";
  final static public  String	strValue_Transparent	= "TRANSPARENT";
  /* 4.8.6.1 Action */
  final static public  String	strValue_Audio		= "AUDIO";
  final static public  String	strValue_Display	= "DISPLAY";
  final static public  String	strValue_EMail		= "EMAIL";
  final static public  String	strValue_Procedure	= "PROCEDURE";
  /* iana-token */
  /* x-name */

}


/* Log:
 *  0.06  2003/10/21, 2003/10/29  slh
 *        ValueType -> Value
 *        4.2.3 Calendar User Type
 *  0.05  2003/01/27, 2003/02/19  slh
 *        (new year, new version...)
 *        FMTTYPE, PARTSTAT, RANGE, ROLE values
 *        CALSCALE, METHOD, STATUS, TRANSP, ACTION values
 *        strParam_TrigRel -> strParam_Related
 *        strProp_TZUrl -> strProp_TZURL
 *        x/iana/unsup*
 *  0.04  2002/10/29, 2002/11/05, 2002/12/02  slh
 *        strValue_{Uri|UtcOffset} -> strValue_{URI|UTCOffset}
 *        *Freebusy* -> *FreeBusy*
 *        strComp_VTimezone -> strComp_VTimeZone
 *        bugfix: strParam_TrigRel value was incorrect
 *        4.2.14 Alarm Trigger Relationship
 *        4.2.9 Free/Busy Time Type
 *        4.2.7 Inline Encoding
 *        4.2.15 Relationship Type
 *        4.3.2   Boolean
 *  0.03  2002/03/05 - 2002/03/06  slh
 *        adjusted for new package location
 *        4.3 Property Value Data Types
 *        strParam_ValueType: ch value: VALUETYPE -> VALUE
 *  0.02  2001/08/14  slh
 *        rm Param/PARAM suffix from parameter names/strings
 *  0.01  2001/06/27, 2001/07/02  slh
 *        4.2 Property Parameters
 *        4.8.1.3 Classification
 *  0.00  2001/05/16  slh
 *        create
 */
/*--Names.java--------------------------------------------------------------*/
