/*++Method.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.HashMap;


/**
 * iCalendar METHOD property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.7.2 [2445]
 *   occurs:	VCALENDAR (0-1)
 *   datatypes:	TEXT/enum (1)
 *   default:	---
 *   allowed:	iana-token
 *   params:	xparam(0+)
 *</PRE>
 *
 * @author  slh
 * @version  0.00 2003/03/05 slh
 */
public
class  Method
extends  EnumProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a METHOD property, set to default.
   */
  public
  Method  (		)
  {
    super( getCalendarName(  ) );
  }


  /**
   * Create a METHOD property set to supplied value.
   */
  public
  Method  (String	strValue	)
  {
    super( getCalendarName(  ) , strValue );
  }


  /**
   * Create a METHOD property set to supplied value.
   *
   * Note: since there are predefined values, this will never work...
   */
  public
  Method  (int	iValue	)
  {
    super( getCalendarName(  ) , iValue );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strProp_Method;
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  /*Note: overriding EnumProp.configEnum()
    which is called in EnumProp.EnumProp(*).
  */
  protected
  void
  configEnum  (		)
  {
    m_hmValue = new HashMap(  );
    /*(void)*/m_hmValue.put( new Integer( IANATOKEN ) , null );

    /* no default */
  }

}


/* Log:
 *  0.10  2003/03/05  slh
 *        redo constructors
 *        configEnum(): drop set(), setEnum()
 *        getCalendarName()
 *  0.00  2001/04/24 - 2001/04/25  slh
 *        create
 */
/*--Method.java-------------------------------------------------------------*/
