/*++Location.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.Vector;


/**
 * iCalendar LOCATION property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.8.1.7 [2445]
 *   occurs:	VEVENT (0-1)
 *   datatypes:	TEXT (1)
 *   default:	---
 *   allowed:	---
 *   params:	*ALTREP(0-1), LANGUAGE(0-1), xparam(0+)
 * * ALTREP is a URI
 *</PRE>
 *
 * @author  slh
 * @version  0.10 2003/04/15 slh
 */
public
class  Location
extends  TextProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a LOCATION property, unset.
   */
  public
  Location  (		)
  {
    super( getCalendarName(  ) );
  }


  /**
   * Create a LOCATION property set to supplied value.
   */
  public
  Location  (String	strValue	)
  {
    super( getCalendarName(  ) , strValue );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strProp_Location;
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  /**
   * Configures property by populating m_vParam*.
   */
  protected
  void
  configProperty  (		)
  {
    m_vParamZeroPlus = new Vector(  );
    m_vParamZeroPlus.add( XParam.class );

    m_vParamZeroOne = new Vector(  );
    m_vParamZeroOne.add( AltRepParam.class );
    m_vParamZeroOne.add( LanguageParam.class );
  }

}


/* Log:
 *  0.10  2003/01/14, 2003/04/15  slh
 *        getCalendarName()
 *        derive directly from TextProp
 *        configProperty()
 *  0.00  2001/04/25  slh
 *        create
 */
/*--Location.java-----------------------------------------------------------*/
