/*++LastModified.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


/**
 * iCalendar LAST-MODIFIED property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.8.7.3 [2445]
 *   occurs:	VEVENT, VTODO, VJOURNAL, VTIMEZONE (0-1)
 *   datatypes:	DATE-TIME/utc (1)
 *   default:	---
 *   allowed:	---
 *   params:	xparam(0+)
 *</PRE>
 *
 * @author  slh
 * @version  0.10 2003/11/04 slh
 */
public
class  LastModified
extends  TimeProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a LAST-MODIFIED property, unset.
   */
  public
  LastModified  (		)
  {
    super( getCalendarName(  ) , DATETIME , true );
  }


  /**
   * Create a LAST-MODIFIED property set to supplied value.
   */
  protected
  LastModified  (String	strValue	)
  {
    super( getCalendarName(  ) , strValue , DATETIME , true );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strProp_LastModified;
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  void
  setType  (int		Type	)
  throws IllegalArgumentException
  {
    if (Type != DATETIME) {
      throw new IllegalArgumentException( getName(  ) + ":setType()" +
		": type can only be DATE-TIME" );
    }

    /*void*/super.setType( Type );
  }

}


/* Log:
 *  0.10  2003/11/04  slh
 *        sync with current paradigms
 *  0.00  2001/05/08 - 2001/05/09  slh
 *        create
 */
/*--LastModified.java-------------------------------------------------------*/
