/*++IntegerProp.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


/**
 * Base class iCalendar INTEGER-valued properties
 * (and base class for some other base classes).
 *
 * Subclassing:
 * Note all set()s are sent through set(int).
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.3.8 [2445]
 *   allowed:	---
 *</PRE>
 *
 * @author  slh
 * @version  0.10 2002/12/10 slh
 */
abstract public
class  IntegerProp
extends  Property
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /*Note: attempting to use the default constructor is wrong*/


  /* this is the base constructor */
  /**
   * Create an INTEGER parameter, unset.
   */
  public
  IntegerProp  (String	strName	)
  {
    super( strName );
  }


  /**
   * Create an INTEGER property set to supplied value.
   */
  protected
  IntegerProp  (String	strName		,
		String	strValue	)
  {
    this( strName );

    /*void*/set( strValue );
  }


  /**
   * Create an INTEGER property set to supplied value.
   */
  protected
  IntegerProp  (String	strName	,
		Integer	IValue	)
  {
    this( strName );

    /*void*/set( IValue );
  }


  /**
   * Create an INTEGER property set to supplied value.
   */
  protected
  IntegerProp  (String	strName	,
		int	iValue	)
  {
    this( strName );

    /*void*/set( iValue );
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  boolean
  isComplete  (		)
  {
    return m_IValue != null && super.isComplete(  );
  }


  public
  int
  get  (		)
  throws NoValueException
  {
    if (m_IValue != null) {
      return m_IValue.intValue(  );
    } else {
      throw new NoValueException( getName(  ) +
		": integer property value is unset" );
    }
  }


  public
  void
  set  (int	iValue	)
  {
    m_IValue = new Integer( iValue );
  }


  public
  void
  set  (Integer	IValue	)
  {
    /*Note: very purposefully funnelling through set(int)*/
    /*void*/set( IValue.intValue(  ) );
  }


  public
  void
  set  (String	strValue	)
  {
    /*Note: very purposefully funnelling through set(int)*/
    /*void*/set( Integer.decode( strValue ) );
  }


  public
  String
  getString  (		)
  {
    return m_IValue == null ? null : m_IValue.toString(  );
  }


/*----------------------------------------------------------------------------
 *						Object Protected Variables
 *--------------------------------------------------------------------------*/

  protected  Integer	m_IValue	= null;

}


/* Log:
 *  0.10  2002/10/30  slh
 *        IntegerParam(String,*)
 *        add getString(), drop toString() (let super do it w/getString())
 *        IntProp -> IntegerProp
 *        isComplete()
 *        funnel all set() through set(int)
 *  0.01  2001/08/14  slh
 *        add: set(String), set(Integer)
 *  0.00  2001/04/24 - 2001/04/25, 2001/05/02  slh
 *        create
 */
/*--IntegerProp.java--------------------------------------------------------*/
