/*++IntegerParam.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


/**
 * Base class for ICalendar INTEGER-valued parameters
 * (and base class for some other base classes).
 *
 * Subclassing:
 * Note all set()s are sent through set(int).
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.3.8 [2445]
 *   allowed:	---
 *</PRE>
 *
 * @author  slh
 * @version  0.10 2002/12/10 slh
 */
abstract public
class  IntegerParam
extends  Parameter
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /*Note: attempting to use the default constructor is wrong*/


  /* this is the base constructor */
  /**
   * Create an INTEGER parameter, unset.
   */
  protected
  IntegerParam  (String	strName	)
  {
    super( strName );
  }


  /**
   * Create an INTEGER parameter set to supplied value.
   */
  protected
  IntegerParam  (String	strName		,
		 String	strValue	)
  {
    this( strName );

    /*void*/set( strValue );
  }


  /**
   * Create an INTEGER parameter set to supplied value.
   */
  protected
  IntegerParam  (String		strName	,
		 Integer	IValue	)
  {
    this( strName );

    /*void*/set( IValue );
  }


  /**
   * Create an INTEGER parameter set to supplied value.
   */
  protected
  IntegerParam  (String	strName	,
		 int	iValue	)
  {
    this( strName );

    /*void*/set( iValue );
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  boolean
  isComplete  (		)
  {
    return m_IValue != null;
  }


  public
  int
  get  (		)
  throws NoValueException
  {
    if (m_IValue != null) {
      return m_IValue.intValue(  );
    } else {
      throw new NoValueException( getName(  ) +
		": integer parameter value is unset" );
    }
  }


  public
  void
  set  (int	iValue	)
  {
    m_IValue = new Integer( iValue );
  }


  public
  void
  set  (Integer	IValue	)
  {
    /*Note: very purposefully funnelling through set(int)*/
    /*void*/set( IValue.intValue(  ) );
  }


  public
  void
  set  (String	strValue	)
  {
    /*Note: very purposefully funnelling through set(int)*/
    /*void*/set( Integer.decode( strValue ) );
  }


  public
  String
  getString  (		)
  {
    return m_IValue == null ? null : m_IValue.toString(  );
  }


/*----------------------------------------------------------------------------
 *						Object Protected Variables
 *--------------------------------------------------------------------------*/

  protected  Integer	m_IValue	= null;

}


/* Log:
 *  0.10  2002/10/30, 2002/12/10  slh
 *        IntegerParam(String,*)
 *        add getString(), drop toString() (let super do it w/getString())
 *        IntParam -> IntegerParam
 *  0.00  2002/10/23  slh
 *        create
 */
/*--IntegerParam.java-------------------------------------------------------*/
