/*++ICalendar.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.StringTokenizer;
import  java.util.Vector;
import  java.util.NoSuchElementException;


/**
 * iCalendar component.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.4 [2445]
 *   occurs:	root (1+)
 *   comps:	0+ (VEVENT, VTODO, VJOURNAL, VFREEBUSY, VTIMEZONE,
 *		iana-comp, x-comp
 *   props:	PRODID(1), VERSION(1), CALSCALE(0-1), METHOD(0-1), x-prop(0+)
 * Must contain at least one component.
 *</PRE>
 *
 * @author  slh
 * @version  0.13 2003/04/29 slh
 */
public
class  ICalendar
extends  Component
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Creates a completely empty calendar.
   */
  public
  ICalendar  (		)
  {
    super( getCalendarName(  ) );
  }


  /**
   * Creates an empty calendar with ProdId and Version set.
   */
  public
  ICalendar  (ProdId	prodid	,
	      Version	version	)
  throws Exception	/* for calls */
  {
    this(  );

    /*Note: addProperty() does null check and throws*/

    addProperty( prodid );
    addProperty( version );
  }


  public
  ICalendar  (String		strProdid	,
	      String		strVersion	)
  throws Exception	/* for calls */
  {
    this(  );

    ProdId		prodid;
    Version		version;

    /*Note: set() and addProperty() do null checks and throw*/
    prodid = new ProdId(  );
    /*void*/prodid.set( strProdid );
    addProperty( prodid );
    version = new Version(  );
    /*void*/version.set( strVersion );
    addProperty( version );
  }


  /**
   * Create a calendar from an unencoded (unmimed, unfolded) ICalendar stream.
   */
  public
  ICalendar  (String	strICalendar	)
  throws Exception
  {
    this(  );

    stringToICalendar( this , strICalendar );
  }

/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strVCalendar;
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  boolean
  isComplete  (		)
  {
    /* check at least one component present */
    if (m_components.size(  ) < 1) {
      return false;						/*RETURN*/
    }

    return super.isComplete(  );				/*RETURN*/
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  protected
  void
  configComponent  (		)
  {
    m_vCompZeroPlus = new Vector(  );
    /*void*/m_vCompZeroPlus.add( VEvent.class );
    /*void*/m_vCompZeroPlus.add( VTodo.class );
    /*void*/m_vCompZeroPlus.add( VJournal.class );
    /*void*/m_vCompZeroPlus.add( VFreeBusy.class );
    /*void*/m_vCompZeroPlus.add( VTimeZone.class );
    /*void*/m_vCompZeroPlus.add( IANAComp.class );
    /*void*/m_vCompZeroPlus.add( XComp.class );

    m_vPropOne = new Vector(  );
    /*void*/m_vPropOne.add( ProdId.class );
    /*void*/m_vPropOne.add( Version.class );
    m_vPropZeroOne = new Vector(  );
    /*void*/m_vPropZeroOne.add( Method.class );
    /*void*/m_vPropZeroOne.add( CalScale.class );

    m_vPropZeroPlus = new Vector(  );
    /*void*/m_vPropZeroPlus.add( XProp.class );
  }


/*-------------------------------------- 	*/

  /**
   * Call super.isComplete().
   *
   * To support subclasses,
   * since calling a specific ancestors method is not allowed.
   */
  protected
  boolean
  isCompleteSuper  (		)
  {
    return super.isComplete(  );				/*RETURN*/
  }


/*-------------------------------------- ICalendar Stream Support	*/

  protected
  void
  stringToICalendar  (ICalendar	icalendar	,
		      String	strICalendar	)
  throws Exception	/* InvalidStreamException */
  {
    StringTokenizer	st;
    String		strToken;

    st = new StringTokenizer( strICalendar , Strings.strDelimiters , true );
    /* if not begin calendar line... */
    if (!st.nextToken(  ).equals( Strings.strBegin ) ||
	!st.nextToken(  ).equals( Strings.strValueInducer ) ||
	!st.nextToken(  ).equals( Names.strVCalendar )) {
      throw new InvalidStreamException( getName(  ) +
		": missing calendar begin" );
    }
    /*void*/eatEOL( null , st );

    /*void*/addComponent( icalendar , null , st );
  }


  protected
  void
  addComponent  (Component		comp	,
		 String			strName	,
		 StringTokenizer	st	)
  throws Exception	/* InvalidStreamException */
  {
    Component	component;
    String	strToken;

    /* if not just adding to existing component... */
    if (strName != null) {
      component = (Component)componentNameToObject( strName );
    } else {
      component = comp;
    }
    strToken = st.nextToken( Strings.strDelimiters );
    /* while not at the end of this component... */
    for ( ; !strToken.equals( Strings.strEnd ) ; ) {
      /* if not the beginning of a (sub)component... */
      if (!strToken.equals( Strings.strBegin )) {
	/* ...must be a property... */
	addProperty( component , strToken , st );
      /* ...else must be the start of a (sub)component... */
      } else {
	if (!st.nextToken(  ).equals( Strings.strValueInducer )) {
	  throw new InvalidStreamException( getName(  ) +
		": value delimiter not found" );
	}
	strToken = st.nextToken(  );	// get name of component
	/*void*/eatEOL( null , st );
	addComponent( component , strToken , st );
      }
      strToken = st.nextToken( Strings.strDelimiters );
    }

    /* if not at end line with matching component name... */
    if (!strToken.equals( Strings.strEnd ) ||
	!st.nextToken(  ).equals( Strings.strValueInducer ) ||
//???
	!st.nextToken(  ).equals( strName ) && strName != null) {
      throw new InvalidStreamException( getName(  ) +
		": missing or nonmatching component end" );
    }
    /*void*/eatEOL( null , st );

    /* if not just adding to existing component... */
    if (strName != null) {
      comp.addComponent( component );
    }
  }


/*???objComp arg will go as will appear inside Component/descendent*/
  protected
  void
  addProperty  (Component	comp	,
		String		strName	,
		StringTokenizer	st	)
  throws Exception	/* InvalidStreamException */
  {
    Property	property;
    String	strToken;

    property = (Property)propertyNameToObject( strName );
    strToken = st.nextToken( Strings.strDelimiters );
    for ( ; strToken.equals( Strings.strParamInducer ) ; ) {
      strToken = st.nextToken(  );			// get param name
      addParameter( property , strToken , st );
      strToken = st.nextToken(  );
    }
    if (strToken.equals( Strings.strValueInducer )) {
      strToken = st.nextToken( Strings.strLineTerm );	// get prop value
      property.set( strToken ); 
      strToken = st.nextToken(  );
    }
    /*void*/eatEOL( strToken , st );

    comp.addProperty( property );
  }


/*???objProp arg will go as will appear inside Property/descendent*/
  protected
  void
  addParameter  (Property		prop	,
		 String			strName	,
		 StringTokenizer	st	)
  throws Exception	/* InvalidStreamException */
  {
    Parameter	parameter;
    String	strToken;

    parameter = (Parameter)parameterNameToObject( strName );
    strToken = st.nextToken( Strings.strDelimiters );
    if (!strToken.equals( Strings.strParamValueInducer )) {
      throw new InvalidStreamException( getName(  ) +
		": missing " + Strings.strParamValueInducer );
    }
    strToken = st.nextToken(  );	// get param value
    parameter.set( strToken );
    prop.addParameter( parameter );
  }


  protected
  Object
  componentNameToObject  (String	strName	)
  throws Exception	/* InvalidStreamException */
  {
    if        (strName.equals( Names.strVCalendar )) {
      return new ICalendar(  );
    } else if (strName.equals( Names.strComp_VEvent )) {
      return new VEvent(  );
/*???x-comp*/
    } else {
      throw new InvalidStreamException( getName(  ) +
		": invalid/unsupported component: " + strName );
    }
  }


  protected
  Object
  propertyNameToObject  (String	strName	)
  throws Exception	/* InvalidStreamException */
  {
    if        (strName.equals( Names.strProp_CalScale )) {
      return new CalScale(  );
    } else if (strName.equals( Names.strProp_Method )) {
      return new Method(  );
    } else if (strName.equals( Names.strProp_ProdId )) {
      return new ProdId(  );
    } else if (strName.equals( Names.strProp_Version )) {
      return new Version(  );
    /* ATTACH unsupported */
    } else if (strName.equals( Names.strProp_Categories )) {
      return new Categories(  );
    } else if (strName.equals( Names.strProp_Class )) {
      return new Class(  );
    } else if (strName.equals( Names.strProp_Comment )) {
      return new Comment(  );
    } else if (strName.equals( Names.strProp_Description )) {
      return new Description(  );
    /* GEO unsupported */
    } else if (strName.equals( Names.strProp_Location )) {
      return new Location(  );
    /* PERCENT-COMPLETE unsupported */
    } else if (strName.equals( Names.strProp_Priority )) {
      return new Priority(  );
    /* RESOURCES unsupported */
    } else if (strName.equals( Names.strProp_Status )) {
      return new Status(  );
    } else if (strName.equals( Names.strProp_Summary )) {
      return new Summary(  );
    /* COMPLETED unsupported */
    } else if (strName.equals( Names.strProp_DTEnd )) {
      return new DTEnd(  );
    /* DUE unsupported */
    } else if (strName.equals( Names.strProp_DTStart )) {
      return new DTStart(  );
    } else if (strName.equals( Names.strProp_Duration )) {
      return new Duration(  );
    /* FREEBUSY unsupported */
    } else if (strName.equals( Names.strProp_Transp )) {
      return new Transp(  );
    /* TZID unsupported */
    /* TZNAME unsupported */
    /* TZOFFSETFROM unsupported */
    /* TZOFFSETTO unsupported */
    /* TZURL unsupported */
    } else if (strName.equals( Names.strProp_Attendee )) {
      return new Attendee(  );
    } else if (strName.equals( Names.strProp_Contact )) {
      return new Contact(  );
    /* ORGANIZER unsupported */
    } else if (strName.equals( Names.strProp_RecurrenceId )) {
      return new RecurrenceId(  );
    /* RELATED-TO unsupported */
    } else if (strName.equals( Names.strProp_URL )) {
      return new URL(  );
    } else if (strName.equals( Names.strProp_UID )) {
      return new UID(  );
    /* EXDATE unsupported */
    /* EXRULE unsupported */
    /* RDATE unsupported */
    /* RRULE unsupported */
    /* ACTION unsupported */
    /* REPEAT unsupported */
    /* TRIGGER unsupported */
    } else if (strName.equals( Names.strProp_Created )) {
      return new Created(  );
    } else if (strName.equals( Names.strProp_DTStamp )) {
      return new DTStamp(  );
    } else if (strName.equals( Names.strProp_LastModified )) {
      return new LastModified(  );
    } else if (strName.equals( Names.strProp_Sequence )) {
      return new Sequence(  );
    /* REQUEST-STATUS unsupported */
    } else if (Config.isXName( strName )) {
      return new XProp( strName );
    } else {
      throw new InvalidStreamException( getName(  ) +
		": invalid/unsupported property: " + strName );
    }
  }


  protected
  Object
  parameterNameToObject  (String	strName	)
  throws Exception	/* InvalidStreamException */
  {
    if (false) {
      return null;
    } else if (strName.equals( Names.strParam_AltRep )) {
      return new AltRepParam(  );
    } else if (strName.equals( Names.strParam_CN )) {
      return new CNParam(  );
    } else if (strName.equals( Names.strParam_CUType )) {
      return new CUTypeParam(  );
    } else if (strName.equals( Names.strParam_DelFrom )) {
      return new DelFromParam(  );
    } else if (strName.equals( Names.strParam_DelTo )) {
      return new DelToParam(  );
    } else if (strName.equals( Names.strParam_Dir )) {
      return new DirParam(  );
    /* ENCODING unsupported */
    /* FMTTYPE unsupported */
    /* FBTYPE unsupported */
    } else if (strName.equals( Names.strParam_Language )) {
      return new LanguageParam(  );
    } else if (strName.equals( Names.strParam_Member )) {
      return new MemberParam(  );
    } else if (strName.equals( Names.strParam_PartStat )) {
      return new PartStatParam(  );
    } else if (strName.equals( Names.strParam_Range )) {
      return new RangeParam(  );
    /* TRIGREL unsupported */
    /* RELTYPE unsupported */
    } else if (strName.equals( Names.strParam_Role )) {
      return new RoleParam(  );
    } else if (strName.equals( Names.strParam_RSVP )) {
      return new RSVPParam(  );
    } else if (strName.equals( Names.strParam_SentBy )) {
      return new SentByParam(  );
    } else if (strName.equals( Names.strParam_TZID )) {
      return new TZIDParam(  );
    /* VALUETYPE unsupported */
    } else if (Config.isXName( strName )) {
      return new XParam( strName );
    } else {
      throw new InvalidStreamException( getName(  ) +
		": invalid/unsupported parameter: " + strName );
    }
  }


  /**
   * Check for and consume proper line termination.
   */
  protected
  void
  eatEOL  (String		strToken	,
	   StringTokenizer	st		)
  throws InvalidStreamException
  {
    String	strTmp		= "";
    
    try {
      strTmp = getDelim( strToken , Strings.strLineTerm , st );
    } catch (NoSuchElementException	e	) {
      ;		/* short string will trigger throw below */
    }

    if (!strTmp.equals( Strings.strLineTerm )) {
      throw new InvalidStreamException( getName(  ) +
		": proper line termination sequence not found" );
    }
  }


  /**
   * Accumulate and return (probably) multi-char line terminator.
   */
  protected
  String
  getDelim  (String		strToken	,
	     String		strDelim	,
	     StringTokenizer	st		)
  throws NoSuchElementException
  {
    String	strTmp		= "";
    int		idx		= 0;

    if (strToken == null) {
      strToken = st.nextToken( strDelim );
    }
    strTmp += strToken;
    idx++;

    for ( ; idx < strDelim.length(  ) ; idx++) {
      strTmp += st.nextToken( strDelim );
    }

    return strTmp;
  }

					
/*----------------------------------------------------------------------------
 *						Class Public Constants
 *--------------------------------------------------------------------------*/
  final static public  String	mc_strModuleName	= "ICalendar";


/*----------------------------------------------------------------------------
 *						Main
 *--------------------------------------------------------------------------*/

  static public
  void
  main  (String	argv[]	)
  {
    ICalendar	icalendar	= null;
    ProdId	prodid		= new ProdId(  );
    Version	version		= new Version(  );
    VEvent	vevent		= new VEvent(  );
    XProp	xprop		= new XProp( "X-CAC-PROPERTY" );
    Class	classx		= new Class(  );
    Status	status		= new Status(  );
    Transp	transp		= new Transp(  );
    Description		description	= new Description(  );
    LanguageParam	languageparam	= new LanguageParam(  );

  /* build calendar by hand */
    try {
      /*void*/prodid.set( "slh/test" );
      /*void*/version.set( "2.0" );
      icalendar	= new ICalendar( prodid , version );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }
    try {
      /*void*/icalendar.addComponent( vevent );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }
    /*void*/System.out.println( "complete?: " + icalendar.isComplete(  ) );
    /*void*/System.out.println( "supported?: " + icalendar.isSupported(  ) );
    /*void*/System.out.println( "======================================" +
				"=====================================" );
    /*void*/System.out.print( icalendar );
    /*void*/System.out.println( "======================================" +
				"=====================================" );

    try {
      /*void*/xprop.set( "zzz" );
      /*void*/status.set( Status.CONFIRMED );
      /*void*/transp.set( "TRANSPARENT" );
      /*void*/description.set( "a description" );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }
    /*void*/languageparam.set( "LANGUAGE=chinese" );
    try {
      /*void*/description.addParameter( languageparam );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }

    try {
      /*void*/vevent.addProperty( xprop );
      /*void*/vevent.addProperty( classx );
      /*void*/vevent.addProperty( status );
      /*void*/vevent.addProperty( transp );
      /*void*/vevent.addProperty( description );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }
    /*void*/System.out.println( "complete?: " + icalendar.isComplete(  ) );
    /*void*/System.out.println( "supported?: " + icalendar.isSupported(  ) );
    /*void*/System.out.println( "======================================" +
				"=====================================" );
    /*void*/System.out.print( icalendar );
    /*void*/System.out.println( "======================================" +
				"=====================================" );
  }

}


/* Note: update class header too */
/* Log:
 *  0.13  2003/01/21 ... 2003/03/05, 2003/04/21, 2003/04/29  slh
 *        (new year, new version...)
 *        back out Config.get{CompProp}Class()
 *        update for change in Transp interface
 *        isCompleteSuper()
 *        getCalendarName()
 *        use Config.get*Class() to get class
 *        expand a catch
 *  0.12  2002/12/10 - 2002/12/11  slh
 *        update for table-driven Component:
 *          drop addComponent() and addProperty() and reduce isComplete()
 *        update for new Component.toString(): drop toString()
 *  0.11  2002/02/27  slh
 *        support XProp, XParam, RecurrenceId, RangeProp
 *        add constructor (String,String)
 *  0.10  2002/02/12 - 2002/02/13, 2002/02/18  slh
 *        move uwcal stuff off to another package/class
 *        move split*() to Utitlities
 *        add: isComplete()
 *        comments, misc
 *  0.03  2001/09/18 .. 2001/09/24, 2001/10/10, 2001/11/13 .. 2001/11/28  slh
 *        various related to xfering keywords, locations and sponsors to uwcal
 *          getAllUsers{Keywords|Locations|Sponsors}()
 *          are{Keywords|Locations|Sponsors}Equal()
 *          checkadd{Keywords|Locations|Sponsors}()
 *        explicit toString()
 *        update for calendar.data changes
 *        misc
 *  0.02  2001/09/11  slh
 *        update for changes in classes
 *  0.01  2001/08/08, 2001/08/13 .. 2001/08/27  slh
 *        contruct from ICalendar data stream
 *        work on uwcal location/sponsor construction
 *  0.00  2001/04/24, 2001/05/01 .. 2001/05/23, 2001/06/19 .. 2001/07/06  slh
 *        create
 */
/*--ICalendar.java----------------------------------------------------------*/
