/*++IANAProp.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.Vector;


/**
 * iCalendar IANA property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * ``
 * contentline        = name *(";" param ) ":" value CRLF
 * ''
 *
 * Spec:
 *   section:	4.1 [2445]
 *   occurs:	0+
 *   datatypes:	TEXT (1)
 *   default:	---
 *   allowed:	---
 *   params:	any
 *</PRE>
 *
 * Note: this should be substantially the same as XProp,
 * except for the allowed parameters.
 *
 * @author  slh
 * @version  0.10 2003/04/23 slh
 */
public
class  IANAProp
extends  TextProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create an IANA property of supplied name, unset.
   */
  public
  IANAProp  (String	strName		)
  {
    super( strName );
  }


  /**
   * Create an IANA property of supplied name set to supplied value.
   */
  public
  IANAProp  (String	strName		,
	     String	strValue	)
  {
    super( strName , strValue );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strProp_IANA;
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  /**
   * Configures property by populating m_vParam*.
   */
  protected
  void
  configProperty  (		)
  {
    m_vParamZeroPlus = new Vector(  );
    m_vParamZeroPlus.add( Parameter.class );
  }

}


/* Log:
 *  0.10  2003/01/21 - 2003/01/22, 2003/04/23  slh
 *        (new year, new version...)
 *        getCalendarName()
 *        derive from TextPropComponent (instead of UnsupComp)
 *        configProperty()
 *        redo constructors
 *  0.00  2002/12/02, 2002/12/10  slh
 *        create
 */
/*--IANAProp.java-----------------------------------------------------------*/
