/*++IANAParam.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


/**
 * iCalendar IANA parameter.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.2 [2445]
 *   occurs:	---
 *   datatypes:	TEXT (1+)
 *   default:	---
 *   allowed:	---
 *</PRE>
 *
 * Note: this should be substantially the same as XParam.
 *
 * @author  slh
 * @version  0.10 2003/04/23 slh
 */
public
class  IANAParam
extends  TextListParam
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create an x property of supplied name, unset.
   */
  public
  IANAParam  (String	strName	)
  {
    super( strName );
  }


  /**
   * Create an x property of supplied name set to supplied value.
   */
  public
  IANAParam  (String	strName		,
	      String	strValue	)
  {
    super( strName , strValue );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strParam_IANA;
  }

}


/* Log:
 *  0.10  2003/01/22, 2003/04/23  slh
 *        (new year, new version...)
 *        getCalendarName()
 *        derive from TextListParam (rather than UnsupParam)
 *        redo constructors
 *  0.00  2002/12/10  slh
 *        create
 */
/*--IANAParam.java----------------------------------------------------------*/
