/*++IANAComp.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.Vector;


/**
 * iCalendar IANA component.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * ``
 * iana-comp  = "BEGIN" ":" iana-token CRLF
 *              1*contentline
 *              "END" ":" iana-token CRLF
 * ''
 * Taking this to mean contents arranged as components and properties,
 * though it does not necessarily mean that.
 *
 *   section:	4.6 [2445]
 *   props:	any
 *   comps:	any
 *</PRE>
 *
 * Note: this should be substantially the same as XComp.
 *
 * @author  slh
 * @version  0.10 2003/04/23 slh
 */
public
class  IANAComp
extends  Component
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create an IANA component of supplied name, unset.
   */
  public
  IANAComp  (String	strName	)
  {
    super( strName );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strComp_IANA;
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  boolean
  isComplete  (         )
  {
    /* ``
     * iana-comp  = "BEGIN" ":" iana-token CRLF
     *              1*contentline
     *              "END" ":" iana-token CRLF
     * ''
     */
    return m_properties != null && m_properties.size(  ) > 0 ||
		m_components != null && m_components.size(  ) > 0;
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  protected
  void
  configComponent  (		)
  {
    m_vCompZeroPlus = new Vector(  );
    m_vCompZeroPlus.add( Component.class );

    m_vPropZeroPlus = new Vector(  );
    m_vPropZeroPlus.add( Property.class );
  }

}


/* Log:
 *  0.10  2003/01/22, 2003/04/23  slh
 *        (new year, new version...)
 *        use base classes for allowed member lists
 *        getCalendarName()
 *        derive directly from Component (instead of UnsupComp)
 *        configComponent(); drop addComponent(), addProperty()
 *        redo constructors
 *  0.00  2002/12/10  slh
 *        create
 */
/*--IANAComp.java-----------------------------------------------------------*/
