/*++Geo.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;



/**
 * Geo: ICalendar Geo property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.8.1.6
 *   occurs:	0-1 (VEVENT,VTODO)
 *   datatypes:	FLOAT (2)
 *   default:	---
 *   allowed:	;-separated
 *   params:	xparam (0+)
 *</PRE>
 *
 * @author slh
 * @version 0.01 2002/11/06 slh
 */
public
class  Geo
extends  TextListFloatProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a GEO property unset.
   */
  /* this is the base constructor */
  public
  Geo  (		)
  {
//???separate calls and try/catch until TextListFloatProp redone
    super( Names.strProp_Geo );
    try {
      setDelim( mc_strDelimiter );
    } catch (Exception	e	) {
      /* this should have happened... */
      throw new InternalError( e.getLocalizedMessage(  ) );
    }
    /*void*/setMinMax( mc_MinElement , mc_MaxElement );
  }


  /**
   * Create a GEO property set to indicated values
   */
  public
  Geo  (String	strValues	)
  {
    this(  );

    try {
      /*void*/set( strValues );
    } catch (Exception	e	) {
      throw new IllegalArgumentException( e.getLocalizedMessage(  ) );
    }
  }


/*----------------------------------------------------------------------------
 *						Class Public Constants 
 *--------------------------------------------------------------------------*/

  final static public  String	mc_strDelimiter		= ";";
  final static public  int	mc_MinElement		= 2;
  final static public  int	mc_MaxElement		= 2;

}


/* Log:
 *  0.01  2002/11/06  slh
 *        update for changed TextListProp
 *        redo constructors
 *  0.00  2001/05/22  slh
 *        create
 */
/*--Geo.java----------------------------------------------------------------*/
