/*++FreeBusy.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.Vector;


/**
 * iCalendar FREEBUSY property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.8.2.6 [2445]
 *   occurs:	VFREEBUSY (0+)
 *   datatypes:	PERIOD (1+)
 *   default:	---
 *   allowed:	comma-separated list
 *   params:	FBTYPE(0-1), xparams (0+)
 *</PRE>
 *
 * @author  slh
 * @version  0.00 2003/02/19 slh
 */
public
class  FreeBusy
extends  PeriodProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  public
  FreeBusy  (		)
  {
    super( getCalendarName(  ) );
  }



  public
  FreeBusy  (String	strValue	)
  {
    super( getCalendarName(  ) , strValue );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strProp_FreeBusy;
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  /**
   * Configures property by populating m_vParam*.
   */
  protected
  void
  configProperty  (		)
  {
    m_vParamZeroOne = new Vector(  );
    /*void*/m_vParamZeroOne.add(
		Config.getParamClass( Names.strParam_FBType ) );

    m_vParamZeroPlus = new Vector(  );
    /*void*/m_vParamZeroPlus.add( Config.getParamClass( Names.strParam_X ) );
  }

}


/* Log:
 *  0.00  2003/02/19  slh
 *        create
 */
/*--FreeBusy.java-----------------------------------------------------------*/
