/*++FmtTypeParam.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.HashMap;


/**
 * ICalendar FMTTYPE parameter.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.2.8 [2445]
 *   occurs:	---
 *   datatypes:	TEXT (1)
 *   default:	---
 *   allowed:	iana-token, x-name
 *</PRE>
 *
 * @author  slh
 * @version  0.00 2003/03/05 slh
 */
public
class  FmtTypeParam
extends  EnumParam
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a FMTTYPE parameter, unset.
   */
  public
  FmtTypeParam  (		)
  {
    super( getCalendarName(  ) );
  }


  /**
   * Create a FMTTYPE parameter set to supplied string value.
   */
  public
  FmtTypeParam  (String	strValue	)
  {
    super( getCalendarName(  ) , strValue );
  }


  /**
   * Create a FMTTYPE parameter set to supplied int value.
   *
   * Note: since there are predefined values, this will never work...
   */
  public
  FmtTypeParam  (int	iValue	)
  {
    super( getCalendarName(  ) , iValue );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strParam_FmtType;
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  /*Note: overriding EnumProp.configEnum()
    which is called in EnumProp.EnumProp(*).
  */
  protected
  void
  configEnum  (		)
  {
    m_hmValue = new HashMap(  );
    /*(void)*/m_hmValue.put( new Integer( IANATOKEN ) , null );
    /*(void)*/m_hmValue.put( new Integer( XNAME ) , null );

    /* no default */
  }


/*----------------------------------------------------------------------------
 *						Main
 *--------------------------------------------------------------------------*/

  static public
  void  main  (String	argv[]	)
  {
    FmtTypeParam	fmttypeparam		= new FmtTypeParam(  );

    /*void*/System.out.println( fmttypeparam );

    try {
      /*void*/fmttypeparam.set( "X-SLH-ENCODING" );
      /*void*/System.out.println( fmttypeparam );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }

    /*void*/System.out.println( fmttypeparam.get(  ) );
    /*void*/System.out.println( fmttypeparam.getEnum(  ) );

    /*void*/System.out.println(
		"Note: this should throw an IllegalArgumentException:" );
    try {
      /*void*/fmttypeparam.set( 666 );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e );
    }
    /*void*/System.out.println(
		"Note: this should throw an IllegalArgumentException:" );
    try {
      /*void*/fmttypeparam.set( "six six six" );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e );
    }
    /*void*/System.out.println( fmttypeparam );
  }

}


/* Log:
 *  0.01  2003/03/05  slh
 *        (new year, new version...)
 *        redo constructors
 *        configEnum()
 *        getCalendarName()
 *  0.00  2002/11/05  slh
 *        create from RelTypeParam.java
 */
/*--FmtTypeParam.java-------------------------------------------------------*/
