/*++FBTypeParam.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.HashMap;


/**
 * iCalendar FBTYPE parameter.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.2.9 [2445]
 *   occurs:	---
 *   datatypes:	TEXT (1)
 *   default:	"BUSY"
 *   allowed:	"FREE", "BUSY", "BUSY-UNAVAILABLE", "BUSY-TENTATIVE",
 *           	iana-token, x-name
 *</PRE>
 *
 * @author  slh
 * @version  0.10 2003/02/05 slh
 */
public
class  FBTypeParam
extends  EnumParam
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a FBTYPE parameter set to default.
   */
  public
  FBTypeParam  (		)
  {
    super( Names.strParam_FBType );
  }


  /**
   * Create a FBTYPE parameter set to supplied string value.
   */
  public
  FBTypeParam  (String	strValue	)
  {
    super( Names.strParam_FBType , strValue );
  }


  /**
   * Create a FBTYPE parameter set to supplied id value.
   */
  public
  FBTypeParam  (int	iValue	)
  {
    super( Names.strParam_FBType , iValue );
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  /*Note: overriding EnumProp.configEnum()
    which is called in EnumProp.EnumProp(*).
  */
  protected
  void
  configEnum  (		)
  {
    m_hmValue = new HashMap(  );
    m_hmValue.put( new Integer( FREE ) , Names.strValue_Free );
    m_hmValue.put( new Integer( BUSY ) , Names.strValue_Busy );
    m_hmValue.put( new Integer( BUSYUNAVAILABLE ) ,
		   Names.strValue_BusyUnavailable );
    m_hmValue.put( new Integer( BUSYTENTATIVE ) ,
		   Names.strValue_BusyTentative );
    m_hmValue.put( new Integer( IANATOKEN ) , null );
    m_hmValue.put( new Integer( XNAME ) , null );

    m_strDefault = Names.strValue_Busy;
  }


/*----------------------------------------------------------------------------
 *						Class Public Constants
 *--------------------------------------------------------------------------*/

  final static public  int	FREE		= 1;
  final static public  int	BUSY		= 2;
  final static public  int	BUSYUNAVAILABLE	= 3;
  final static public  int	BUSYTENTATIVE	= 4;


/*----------------------------------------------------------------------------
 *						Main
 *--------------------------------------------------------------------------*/

  static public
  void  main  (String	argv[]	)
  {
    FBTypeParam		fbtypeparam	= new FBTypeParam(  );

    /*void*/System.out.println( fbtypeparam );

    try {
      /*void*/fbtypeparam.set( "FREE" );
      /*void*/System.out.println( fbtypeparam );

      /*void*/fbtypeparam.set( BUSYUNAVAILABLE );
      /*void*/System.out.println( fbtypeparam );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }

    /*void*/System.out.println( fbtypeparam.get(  ) );
    /*void*/System.out.println( fbtypeparam.getEnum(  ) );

    /*void*/System.out.println(
		"NOTE: should throw IllegalArgumentException:" );
    try {
      /*void*/fbtypeparam.set( 666 );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e );
    }
    /*void*/System.out.println(
		"NOTE: should throw IllegalArgumentException:" );
    try {
      /*void*/fbtypeparam.set( "six six six" );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e );
    }
    /*void*/System.out.println( fbtypeparam );
  }

}


/* Log:
 *  0.10  2003/02/05  slh
 *        (new year, new version...)
 *        configEnum(), etc
 *        actually allow iana-token and x-name
 *        redo constructors
 *  0.00  2002/11/05  slh
 *        create
 */
/*--FBTypeParam.java--------------------------------------------------------*/
