/*++ExDate.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.Vector;


/**
 * iCalendar EXDATE property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 *   section:	4.8.5.1 [2445]
 *   occurs:	VEVENT, VTODO, VJOURNAL (0+)
 *   datatypes:	DATE-TIME, DATE (1+)
 *   default:	---
 *   allowed:	---
 *   params:	VALUE(0-1), TZID(0-1), xparam(0+)
 *</PRE>
 *
 * @author  slh
 * @version  0.01 2003/10/29 slh
 */
public
class  ExDate
extends  UnsupProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create an EXDATE property, unset.
   */
  public
  ExDate  (		)
  {
    super( getCalendarName(  ) );
  }


  /**
   * Create an EXDATE property set to supplied value.
   */
  public
  ExDate  (String	strValue	)
  {
    super( getCalendarName(  ) , strValue );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strProp_ExDate;
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  protected
  void
  configProperty  (		)
  {
    m_vParamZeroOne = new Vector(  );
    /*void*/m_vParamZeroOne.add( ValueParam.class );
    /*void*/m_vParamZeroOne.add( TZIDParam.class );

    m_vParamZeroPlus = new Vector(  );
    /*void*/m_vParamZeroPlus.add( XParam.class );
  }

}


/* Log:
 *  0.01  2003/10/29  slh
 *        sync with current paradigms
 *        adjust for ValueTypeParam -> ValueType
 *  0.00  2003/02/12  slh
 *        create
 */
/*--ExDate.java-------------------------------------------------------------*/
