/*++EncodingParam.java++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.HashMap;


/**
 * iCalendar ENCODING parameter.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.2.7 [2445]
 *   occurs:	---
 *   datatypes:	TEXT (1)
 *   default:	"8BIT"
 *   allowed:	"8BIT", "BASE64", iana-token, x-name
 *</PRE>
 *
 * @author  slh
 * @version  0.10 2003/02/05 slh
 */
public
class  EncodingParam
extends  EnumParam
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a ENCODING parameter set to default.
   */
  public
  EncodingParam  (		)
  {
    super( Names.strParam_Encoding );
  }


  /**
   * Create a ENCODING parameter set to supplied string value.
   */
  public
  EncodingParam  (String	strValue	)
  {
    super( Names.strParam_Encoding , strValue );
  }


  /**
   * Create a ENCODING parameter set to supplied id value.
   */
  public
  EncodingParam  (int	iValue	)
  {
    super( Names.strParam_Encoding , iValue );
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  /*Note: overriding EnumProp.configEnum()
    which is called in EnumProp.EnumProp(*).
  */
  protected
  void
  configEnum  (		)
  {
    m_hmValue = new HashMap(  );
    m_hmValue.put( new Integer( E8BIT ) , Names.strValue_8Bit );
    m_hmValue.put( new Integer( BASE64 ) , Names.strValue_Base64 );
    m_hmValue.put( new Integer( IANATOKEN ) , null );
    m_hmValue.put( new Integer( XNAME ) , null );

    m_strDefault = Names.strValue_8Bit;
  }


/*----------------------------------------------------------------------------
 *						Class Public Constants
 *--------------------------------------------------------------------------*/

  final static public  int	E8BIT		= 1;
  final static public  int	BASE64		= 2;


/*----------------------------------------------------------------------------
 *						Main
 *--------------------------------------------------------------------------*/

  static public
  void  main  (String	argv[]	)
  {
    EncodingParam	encodingparam	= new EncodingParam(  );

    /*void*/System.out.println( encodingparam );

    try {
      /*void*/encodingparam.set( "BASE64" );
      /*void*/System.out.println( encodingparam );

      /*void*/encodingparam.set( E8BIT );
      /*void*/System.out.println( encodingparam );

      /*void*/encodingparam.set( "X-SLH-TRA" );
      /*void*/System.out.println( encodingparam );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }

    /*void*/System.out.println( encodingparam.get(  ) );
    /*void*/System.out.println( encodingparam.getEnum(  ) );

    /*void*/System.out.println(
		"NOTE: should throw IllegalArgumentException:" );
    try {
      /*void*/encodingparam.set( 666 );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e );
    }
    /*void*/System.out.println(
		"NOTE: should throw IllegalArgumentException:" );
    try {
      /*void*/encodingparam.set( "six six six" );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e );
    }
    /*void*/System.out.println( encodingparam );
  }

}


/* Log:
 *  0.10  2003/02/05  slh
 *        (new year, new version...)
 *        configEnum(), etc
 *        actually allow iana-token and x-name
 *        redo constructors
 *  0.00  2002/11/05  slh
 *        create from RelTypeParam.java
 */
/*--EncodingParam.java------------------------------------------------------*/
