/*++Duration.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


/**
 * iCalendar DURATION property.
 *
 * Spec:
 *   section:	4.8.2.5 [2445]
 *   occurs:	VEVENT, VTODO, VFREEBUSY, VALARM (0-1)
 *   datatypes:	DURATION (1)
 *   default:	---
 *   allowed:	---
 *   params:	xparam (0+)
 *
 * @author  slh
 * @version  0.01 2003/10/08 slh
 */
public
class  Duration
extends  DurationProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create an DURATION property, unset.
   */
  public
  Duration  (		)
  {
    super( getCalendarName(  ) );
  }


  /**
   * Create a DURATION property set to supplied value.
   */
  public
  Duration  (String	strValue	)
  {
    super( getCalendarName(  ) , strValue );
  }


  /**
   * Create an DURATION property set to supplied value.
   */
  public
  Duration  (Integer	IValue	)
  {
    super( getCalendarName(  ) , IValue );
  }


  /**
   * Create an DURATION property set to supplied value.
   */
  public
  Duration  (int	iValue	)
  {
    super( getCalendarName(  ) , iValue );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strProp_Duration;
  }

}


/* Log:
 *  0.01  2003/10/08  slh
 *        redo to current patterns
 *  0.00  2001/08/20  slh
 *        create
 */
/*--Duration.java-----------------------------------------------------------*/
