/*++Due.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.Vector;


/**
 * iCalendar DUE property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.8.2.3 [2445]
 *   occurs:	VTODO (0-1)
 *   datatypes:	DATE-TIME, DATE (1)
 *   default:	---
 *   allowed:	---
 *   params:	VALUE(0-1)*, TZID(0-1), xparam(0+)
 * * may be set implicitly
 *</PRE>
 *
 * @author  slh
 * @version  0.20 2003/11/04 slh
 */
public
class  Due
extends  TimeProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a DUE property, unset.
   */
  public
  Due  (		)
  {
    super( getCalendarName(  ) , DATETIME , false );
  }


  /**
   * Create a DUE property set to supplied value.
   */
  protected
  Due  (String	strValue	)
  {
    super( getCalendarName(  ) , strValue , DATETIME , false );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strProp_Due;
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  /**
   * Set value type.
   */
  public
  void
  setType  (int		Type	)
  throws IllegalArgumentException
  {
    if (Type != DATETIME && Type != DATE) {
      throw new IllegalArgumentException( getName(  ) + ":setType()" +
		": type can only be DATE-TIME or DATE" );
    }

    /*void*/super.setType( Type );
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  /**
   * Configures property by populating m_vParam*.
   */
  protected
  void
  configProperty  (		)
  {
    m_vParamZeroPlus = new Vector(  );
    m_vParamZeroPlus.add( XParam.class );

    m_vParamZeroOne = new Vector(  );
    m_vParamZeroOne.add( ValueParam.class );
    m_vParamZeroOne.add( TZIDParam.class );
  }

}


/* Log:
 *  0.20  2003/11/03, 2003/11/04  slh
 *        update for changes in TimeProp, ValueTypeParam -> ValueParam; misc
 *  0.10  2003/01/14, 2003/04/15  slh
 *        getCalendarName()
 *        configProperty()
 *  0.00  2002/03/06  slh
 *        create from DTEnd
 */
/*--Due.java----------------------------------------------------------------*/
