/*++Description.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.Vector;


/**
 * iCalendar DESCRIPTION property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.8.1.5 [2445]
 *   occurs:	VEVENT, VTODO, VALARM (0-1), VJOURNAL(0+)
 *   datatypes:	TEXT (1)
 *   default:	---
 *   allowed:	---
 *   params:	ALTREP(0-1), LANGUAGE(0-1), xparam(0+)
 *</PRE>
 *
 * @author  slh
 * @version  0.10a 2003/10/29 slh
 */
public
class  Description
extends  TextProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a DESCRIPTION property, unset.
   */
  public
  Description  (		)
  {
    super( getCalendarName(  ) );
  }


  /**
   * Create a DESCRIPTION property set to supplied value.
   */
  public
  Description  (String	strValue	)
  {
    super( getCalendarName(  ) , strValue );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strProp_Description;
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  /**
   * Configures property by populating m_vParam*.
   */
  protected
  void
  configProperty  (		)
  {
    m_vParamZeroPlus = new Vector(  );
    m_vParamZeroPlus.add( XParam.class );

    m_vParamZeroOne = new Vector(  );
    m_vParamZeroOne.add( AltRepParam.class );
    m_vParamZeroOne.add( LanguageParam.class );
  }


/*----------------------------------------------------------------------------
 *						Main
 *--------------------------------------------------------------------------*/

  static public
  void  main  (String	argv[]	)
  {
    Description		description	= new Description(  );
    XParam		xparam		= new XParam( "X-cac-xxx" );
    AltRepParam		altrepparam	= new AltRepParam(  );
    LanguageParam	languageparam	= new LanguageParam(  );

    /*void*/System.out.println( description );

    try {
      /*void*/description.set( "a description" );
      /*void*/System.out.println( description );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }

    try {
      /*void*/xparam.set( "yyy" );
      /*void*/description.addParameter( xparam );
      /*void*/System.out.println( description );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }

    try {
      /*void*/altrepparam.set( "altrep" );
      /*void*/languageparam.set( "language" );
      /*void*/description.addParameter( altrepparam );
      /*void*/description.addParameter( languageparam );
      /*void*/System.out.println( description );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }

    /*void*/System.out.println(
		"NOTE: should thrown an InvalidParameterException:" );
    try {
      /*void*/description.addParameter( altrepparam );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e );
    }
    /*void*/System.out.println( description );
  }

}


/* Log:
 *  0.10a 2003/10/29  slh
 *        comments; minor main() change
 *  0.10  2003/01/14, 2003/04/15  slh
 *        getCalendarName()
 *        derive directly from TextProp
 *        configProperty()
 *  0.00  2001/04/25, 2001/05/02, 2001/05/08  slh
 *        create
 */
/*--Description.java--------------------------------------------------------*/
