/*++DTStart.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


import  java.util.Vector;


/**
 * iCalendar DTSTART property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.8.2.4 [2445]
 *   occurs:	VEVENT, VTODO, VFREEBUSY (0-1), VTIMEZONE (1)
 *   datatypes:	DATE-TIME, DATE (1)
 *   default:	---
 *   allowed:	---
 *   params:	VALUE(0-1)*, TZID(0-1), xparam(0+)
 * * may be set implicitly
 *</PRE>
 *
 * @author  slh
 * @version  0.20 2003/11/04 slh
 */
public
class  DTStart
extends  TimeProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a DTSTART property, unset.
   */
  public
  DTStart  (		)
  {
    super( getCalendarName(  ) , DATETIME , false );
  }


  /**
   * Create a DTSTART property set to supplied value.
   */
  protected
  DTStart  (String	strValue	)
  {
    super( getCalendarName(  ) , strValue , DATETIME , false );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strProp_DTStart;
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  void
  setType  (int		Type	)
  throws IllegalArgumentException
  {
    if (Type != DATETIME && Type != DATE) {
      throw new IllegalArgumentException( getName(  ) + ":setType()" +
		": type can only be DATE-TIME or DATE" );
    }

    /*void*/super.setType( Type );
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  protected
  void
  configProperty  (		)
  {
    m_vParamZeroPlus = new Vector(  );
    m_vParamZeroPlus.add( XParam.class );

    m_vParamZeroOne = new Vector(  );
    m_vParamZeroOne.add( ValueParam.class );
    m_vParamZeroOne.add( TZIDParam.class );
  }

}


/* Log:
 *  0.20  2003/11/04  slh
 *        redo constructors; rm set(); misc
 *        update for ValueTypeParam -> ValueParam
 *  0.10  2003/01/14, 2003/04/15  slh
 *        getCalendarName()
 *        configProperty()
 *  0.01  2002/03/05 - 2002/03/06  slh
 *        adjusted for new package location
 *        use Names
 *        javadoc comments
 *  0.00  2001/05/08 - 2001/05/09  slh
 *        create
 */
/*--DTStart.java------------------------------------------------------------*/
