/*++DTStamp.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


/**
 * iCalendar DTSTAMP property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.8.7.2 [2445]
 *   occurs:	VEVENT, VTODO, VJOURNAL, VFREEBUSY (0-1)
 *   datatypes:	DATE-TIME/utc (1)
 *   default:	---
 *   allowed:	---
 *   params:	xparam(0+)
 *</PRE>
 *
 * @author  slh
 * @version  0.10 2003/11/04 slh
 */
public
class  DTStamp
extends  TimeProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a DTSTAMP property, unset.
   */
  public
  DTStamp  (		)
  {
    super( getCalendarName(  ) , DATETIME , true );
  }


  /**
   * Create a DTSTAMP property set to supplied value.
   */
  protected
  DTStamp  (String	strValue	)
  {
    super( getCalendarName(  ) , strValue , DATETIME , true );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strProp_DTStamp;
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  void
  setType  (int		Type	)
  throws IllegalArgumentException
  {
    if (Type != DATETIME) {
      throw new IllegalArgumentException( getName(  ) + ":setType()" +
		": type can only be DATE-TIME" );
    }

    /*void*/super.setType( Type );
  }

}


/* Log:
 *  0.10  2003/11/04  slh
 *        sync with current paradigms
 *  0.00  2001/05/08 - 2001/05/09  slh
 *        create
 */
/*--DTStamp.java------------------------------------------------------------*/
