/*++Created.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.icalendar;


/**
 * iCalendar CREATED property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	4.8.7.1 [2445]
 *   occurs:	VEVENT, VTODO, VJOURNAL (0-1)
 *   datatypes:	DATE-TIME/utc (1)
 *   default:	---
 *   allowed:	---
 *   params:	xparam(0+)
 *</PRE>
 *
 * @author  slh
 * @version  0.10 2003/11/04 slh
 */
public
class  Created
extends  TimeProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a CREATED property, unset.
   */
  public
  Created  (		)
  {
    super( getCalendarName(  ) , DATETIME , true );
  }


  /**
   * Create a CREATED property set to supplied value.
   */
  protected
  Created  (String	strValue	)
  {
    super( getCalendarName(  ) , strValue , DATETIME , true );
  }


/*----------------------------------------------------------------------------
 *						Class Public Methods
 *--------------------------------------------------------------------------*/

  static public
  String
  getCalendarName  (		)
  {
    return Names.strProp_Created;
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  void
  setType  (int		Type	)
  throws IllegalArgumentException
  {
    if (Type != DATETIME) {
      throw new IllegalArgumentException( getName(  ) + ":setType()" +
		": type can only be DATE-TIME" );
    }

    /*void*/super.setType( Type );
  }

}


/* Log:
 *  0.10  2003/11/04  slh
 *        sync with current paradigms
 *  0.01  2002/03/05 - 2002/03/06  slh
 *        adjusted for new package location
 *        use Names
 *        javadoc comments
 *  0.00  2001/05/08 - 2001/05/09  slh
 *        create
 */
/*--Created.java------------------------------------------------------------*/
